<?php
App::uses('AppController', 'Controller');

/**
 * TinyMceImagePickerController
 *
 * Allows for the "selection"/"picking" of images from the admin CMS screen. It effectively
 * handles the loading of the screen that appears
 *
 * @property Event $Event
 * @property PaginatorComponent $Paginator
 */
class ImagePickerController extends AppController {

	/**
	 * just a permissions setup
	 */
	public $adminActions = array(
		'admin_select'
	);

/**
 * Handles the selection of images inside a tinymce wysiwyg editor
 *
 * @param string $primaryKey Model's ID
 * @param string $modelAlias Model's alias
 */
	public function admin_select($primaryKey, $modelAlias) {
		$this->layout = false;

		// assign the image dimensions, defined in the config
		$imageDimensions = Configure::read('EvTinyMceImage.dimensions');

		if (!empty(Configure::read('EvTinyMceImage.' . $modelAlias . '.dimensions'))) {
			$imageDimensions = Configure::read('EvTinyMceImage.' . $modelAlias . '.dimensions');
		}

		$this->set(compact('imageDimensions'));

		$ImageModel = ClassRegistry::init('EvCore.Image');

		$images = $ImageModel->find('all', [
			'conditions' => [
				'Image.model_id' => $primaryKey,
				'Image.model' => $modelAlias,
			],
			'recursive' => 1
		]);

		$this->set('images', $images);

		return;
	}
}
