<?php
App::uses('AppComponent', 'Controller');

class TinyMCEComponent extends AppComponent {

/**
 * Before render logic. We want to check here if we're serving the admin_edit page and set up
 * EvTinyMceImage in the form fields if it is.
 * @param Controller $controller The associated controller
 * @return void
 */
	public function beforeRender(Controller $controller) {
		parent::beforeRender($controller);
		if ($controller->action === 'admin_edit' && ! empty($controller->request->params['pass'][0])) {
			$params = [
				'primaryKey' => $controller->request->params['pass'][0],
				'modelAlias' => ! empty($this->settings['model_alias']) ? $this->settings['model_alias'] : $controller->{$controller->modelClass}->alias
			];
			// Add the config to the form fields using a hidden field with no name attribute so that
			// it doesn't get posted with the form data.
			$controller->viewVars['fields']['EvTinyMceImage.config'] = [
				'name' => '',
				'type' => 'hidden',
				'data-config' => json_encode($params)
			];
		}

		return;
	}
}
