<?php

App::uses('EvTestimonialsAppModel', 'EvTestimonials.Model');

class Testimonial extends EvTestimonialsAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'author';

/**
 * Constructor. Binds the model's database table to the object.
 *
 * @param bool|int|string|array $id Set this ID for this model on startup,
 * can also be an array of options, see above.
 * @param string $table Name of database table to use.
 * @param string $ds DataSource connection name.
 * @return void.
 */
	public function __construct($id = false, $table = null, $ds = null) {
		// bring in the config based image slot settings
		$configImageSlots = Configure::read('EvTestimonials.imageSlots');

		// assign, or merge, the config based image slots declaration
		if (! empty($configImageSlots)) {
			if (! empty($this->imageSlots)) {
				$this->imageSlots = array_merge(
					$configImageSlots,
					$this->imageSlots
				);
			} else {
				$this->imageSlots = $configImageSlots;
			}
		}

		parent::__construct($id, $table, $ds);
	}

/**
 * Query array for getting testimonials
 * Default settings are for listing
 *
 * @return 	array
 */
	public function listingQueryArray() {
		$params = array(
			'conditions' => array(
				'Testimonial.is_active' => 1
			),
			'order' => 'Testimonial.sequence ASC',
		);

		if (!empty($this->imageSlots)) {
			if (is_array($this->imageSlots)) {
				foreach ($this->imageSlots as $slotName => $slot) {
					if (strtolower($slotName) == 'main') {
						$params['contain'][] = 'Image';
						continue;
					}

					$params['contain'][] = $slotName . 'Image';
				}
			} else {
				$params['contain'][] = 'Image';
			}
		}

		// add the limit if the config file has paginate set
		if (Configure::read('EvTestimonials.paginate')) {
			$params['limit'] = Configure::read('EvTestimonials.page_limit');
		}

		return $params;
	}

}
