<?php

App::uses('EvTestimonialsAppController', 'EvTestimonials.Controller');
App::uses('ArrayUtil', 'EvCore.Lib');

class TestimonialsController extends EvTestimonialsAppController {

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'index',
			'view'
		));
	}

	public function index() {
		$Model = $this->{$this->modelClass};

		// Get the page details for headers / meta data
		$pageId = Configure::read('EvTestimonials.page_id');

		if (! empty($pageId)) {
			$this->assignPage($pageId);
		}

		$params = $Model->listingQueryArray();

		// get the actual testimonials - either paginated or a regular find based on plugin config
		if (Configure::read('EvTestimonials.paginate')) {
			$this->paginate = $params;
			$testimonials = $this->paginate();
		} else {
			$testimonials = $this->Testimonial->find('all', $params);
		}

		$this->set('testimonials', $testimonials);

		$this->view = 'EvTestimonials.Testimonials/index';
	}

	/**
	 * amend the whitelist to show the location as well
	 */
	protected function _adminIndexColumnsWhitelist() {
		$modelAlias = $this->{$this->modelClass}->alias;

		$fields = parent::_adminIndexColumnsWhitelist();

		$fields[] = $modelAlias . '.location';

		return $fields;
	}

}
