# EvTestimonials

Simple plugin for having testimonials on your site.

Has the ability to have a paginated list of testimonials.

Also includes a component for loading testimonials as a widget on certain pages.

# Installation

This is a composer plugin so from www/app just run composer as:-

    composer require evoluted/testimonials 2.1.* --prefer-source

To setup the database use the CakeDC Migrations plugin. To run the migrations and setup the database run:-

    Console/cake Migrations.migration run all --plugin EvTestimonials

Add the following to the plugin load array in 'app/Config/bootstrap.php':-

	'EvTestimonials' => array(
		'bootstrap' => true,
		'routes' => true
	)

You will want to add an item to the admin menu for managing testimonials:-

* /admin/ev_testimonials/testimonials/

To setup/override the plugin's default config create a new config file 'app/Config/Plugin/ev_testimonials.php'. The following options are available:-

* page_id - The page id to load for meta data use on the testimonials page.
* page_limit - Number of testimonials to show per page
* routes - Route sub array for routing incase of overwriting the controller.

# Using EvTestimonials

A simple listing page is accessible via /testimonials

This page simply lists the active testimonials in a paginated format.

The template for this can be overwritten using the standard Cake plugin template overriding by creating a file at:

	app/View/Plugin/EvTestimonials/Testimonials/index.ctp

The plugin also comes with a Component to be used for placing testimonials on a none plugin page, i.e. sidebar of homepage.

In your controller where you want the testimonials to appear (i.e. getHomepageExtras or AppController::beforeRender()) place the following code to load the testimonials
and add to the template

	$this->Testimonials = $this->Components->load('EvTestimonials.Testimonials');
	$this->set(
		'testimonials',
		$this->Testimonials->testimonialsWidget()
	);

Then in your template call the following template code

	<?php if (isset($testimonials) && ! empty($testimonials)): ?>

		<?php foreach ($testimonials as $testimonial): ?>

			<?php echo $this->Element('EvTestimonials.widget', array('item' => $testimonial)); ?>

		<?php endforeach; ?>

	<?php endif; ?>

Again, this element can be overwritten using the standard Cake plugin template overriding:

	app/View/Plugin/EvTestimonials/Elements/widget.ctp


# Extending Plugin

The usual rules apply, don't edit the plugin directly but override it from within your own app.
