<?php

App::uses('EvTestimonialsAppModel', 'EvTestimonials.Model');

class Testimonial extends EvTestimonialsAppModel
{
/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'author';

	public $imageSlots = array(
		'main' => array(
			'fields' => array(
				'alt'
			),
			'slots' => 1
		)
	);

/**
 * Query array for getting testimonials
 * Default settings are for listing
 *
 * @return 	array
 */
	public function listingQueryArray() {
		return array(
			'conditions' => array(
				'Testimonial.is_active' => 1
			),
			'order' => 'Testimonial.sequence ASC',
			'contain' => 'Image',
			'limit' => Configure::read('EvTestimonials.page_limit')
		);
	}

}
