<?php

App::uses('Testimonial', 'EvTestimonials.Model');

class TestimonialableBehavior extends ModelBehavior {

	public $settings = array();


/**
 * Initialise the behavior - store the settings against the model
 *
 * @see ModelBehavior::setup()
 */
	public function setup(Model $Model, $settings = array()) {

		$this->settings[$Model->alias] = $settings;
		return;
	}


/**
 * Insert testimonial into find results.
 *
 * @see ModelBehavior::afterFind()
 */
	public function afterFind(Model $Model, $data, $primary=false) {

		$Testimonial = new Testimonial();

		foreach ($data as &$item) {

			if (isset($item[$Model->alias]) && ! empty($item[$Model->alias]['id'])) {

				$testimonialData = $Testimonial->find('first', array(
					'conditions' => array(
						'model' => $Model->alias,
						'model_id' => $item[$Model->alias]['id']
					)
				));

				if (isset($testimonialData['Testimonial'])) {

					$item['Testimonial'] = $testimonialData['Testimonial'];
				}
			}
		}

		return $data;
	}


/**
 * Prepare the data for saving.
 *
 * @see ModelBehavior::beforeSave()
 */
	public function beforeSave(Model $Model, $options=array()) {

		if (isset($Model->data[$Model->alias]['Testimonial'])) {

			$Model->data['Testimonial'] = $Model->data[$Model->alias]['Testimonial'];
			unset($Model->data[$Model->alias]['Testimonial']);
		}

		return parent::beforeSave($Model, $options);
	}


/**
 * Save the testimonial
 *
 * @see ModelBehavior::afterSave()
 */
	public function afterSave(Model $Model, $created, $options=array()) {

		parent::afterSave($Model, $created, $options);

		$Model->data['Testimonial']['model'] = $Model->alias;
		$Model->data['Testimonial']['model_id'] = $Model->id;

		$Testimonial = new Testimonial();
        $Testimonial->create();
        $Testimonial->save($Model->data);

		return;
	}

}