<?php

App::uses('EvTestimonialsAppController', 'EvTestimonials.Controller');
App::uses('ArrayUtil', 'EvCore.Lib');

class TestimonialsController extends EvTestimonialsAppController
{
	public function beforeFilter()
	{
		parent::beforeFilter();

		$this->Auth->allow(array(
			'index',
			'view'
		));
	}

	public function index()
	{
		$Model = $this->{$this->modelClass};

		// Get the page details for headers / meta data
		$page_id = Configure::read('EvTestimonials.page_id');

		if (! empty($page_id)) {

			$this->assignPage($page_id);
		}

		// get the actual testimonials
		$this->paginate = $Model->listingQueryArray();
		$testimonials = $this->paginate();

		$this->set('testimonials', $testimonials);

		$this->view = 'EvTestimonials.Testimonials/index';
	}


	/**
	 * amend the whitelist to show the location as well
	 */
	protected function _adminIndexColumnsWhitelist()
	{
		$modelAlias = $this->{$this->modelClass}->alias;

		$fields = parent::_adminIndexColumnsWhitelist();

		$fields[] = $modelAlias . '.location';

		return $fields;
	}

}
