$(document).ready(function() {

    if ($('.ev-templates-template-selector').length > 0) {

        $(document).on('change', '.ev-templates-template-selector', function() {
            var templateId = parseInt($(this).val());

            if (isNaN(templateId)) {
            	// No template hide tab
            	$('.tab__content.custom-field-data').addClass('hidden');
            	initTabs();
                return false;
            }

            // block the user from switching tabs
            blockTabs();

            var fieldsUrl = '/ajax/ev_templates/templates/getFieldsForTemplate/' + templateId;
            var mediaUrl  = '/ajax/ev_templates/templates/getMediaForTemplate/' + templateId;

            var model = $('.field-data').data('active-model');
            if (model.length > 0) {

                fieldsUrl += '/' + model;
                mediaUrl += '/' + model;
            }

            // check for the model / id. Passed to the switcher so we can pre-populate any content in the fields
            var modelId = parseInt($('.field-data').data('active-model-id'));
            if (typeof modelId === 'number' && modelId >= 0 && model.length > 0) {

                fieldsUrl += '/' + modelId;
                mediaUrl += '/' + modelId;
            } else {
                fieldsUrl += '/0';
                mediaUrl += '/0';
            }

            var method = 'GET';
            var data = '';

            if ($('body').data('cf-validation')) {

                method = 'POST';
                data = {
                    'validationErrors': jQuery.parseJSON($('body').data('cf-validation'))
                };
            }

            $.when(

                // get the fields biased on template
                $.ajax({
                    'type': method,
                    'data': data,
                    'url': fieldsUrl,
                    'cache': false,
                    success: function(data, textStatus, jqXHR) {

                    	 // $('.img-docs-section').html(data);
                        $('.custom-fields-section').html(data);

                        if ($('.custom-fields-section').children().length > 0) {
                        	//Tab has fields, show tab if hidden
                        	$('.custom-fields-section').removeClass('hidden');
                        } else {
                        	//Tab is empty so hide it
                        	$('.custom-fields-section').addClass('hidden');
                        }
                    }
                }),

                // get the images / docs biased on template
                $.ajax({
                    'url': mediaUrl,
                    'cache': false,
                    success: function(data, textStatus, jqXHR) {

                        $('.img-docs-section').html(data);
                    }
                })
            ).then(function() {

                initTabs();

                if ($('.custom-field-data').find('.datepicker').length > 0) {
                    initDatePicker();
                }

                if ($('.custom-field-data').find('.datetimepicker').length > 0) {
                    initDateTimePicker();
                }

                if ($('.custom-field-data').find('.map').length > 0) {
                    loadGoogleMaps();
                }

                if ($('.custom-field-data').find('.wysiwyg').length > 0) {
                    initWYSIWYG($('.custom-field-data'));
                }

                if ($('.img-docs-section').length > 0) {
                    if ($('.img-docs-section').find('.img-tab').length > 0) {
                        loadPreviews();
                        initImages();
                    }

                    if ($('.img-docs-section').find('.doc-tab').length > 0) {
                        initDocuments();
                    }

                    // Hide add new image button if we have used all our slots up already.
                    $('.file-wrapper[data-type*=Image]').each(function(index, element){
                      var $wrapper = $(this).parent().find('.file-wrapper');
                      checkFileLimit($wrapper, 'image', true);
                    });

                    // Hide add new document button if we have used all our slots up already.
                    $('.file-wrapper[data-type*=Document]').each(function(index, element){
                      var $wrapper = $(this).parent().find('.file-wrapper');
                      checkFileLimit($wrapper, 'document', true);
                    });
                }
            });
        });

        $('.ev-templates-template-selector').trigger('change');

    } else {
        alert('The template selector class could not be found, make sure formInject => true is set on the Template Behaviour');
    }

    $('.ev-templates-template-selector').parent().parent().parent().after('<div class="tpl_preview col-sm-offset-2 col-md-offset-3" style="display:none;" data-toggle="modal" data-target="#templateModal"></div>');

    $('.ev-templates-template-selector').on('change', function() {
        $('.tpl_preview').slideUp();
        $('.tpl_preview').before('<div class="tpl_loading col-sm-offset-2 col-md-offset-3"><i class="fa fa-spin fa-cog"></i> Loading...</div>');
        var tpl_id = $(this).val();

        $('.tpl_preview').load('/admin/ev_templates/templates/tpl_preview_img/' + tpl_id, function() {
            $('.tpl_preview').delay(1000).slideDown().parent().find('.tpl_loading').slideUp('fastest').remove();
        });

    });

    $(document).on('hidden.bs.modal', '#templateModal', function () {
        $('.modal-backdrop').remove();
    });

});
