# EvTemplates

Template manager for increase template reusage among modules

## Templates

Place all templates within `app/View/Templates/`. The admin will search this directory for all templates to show in the admin drop down menu. The search is recursive so sub-folders can be used to help organise and group templates.

### Admin Helper Functions

If you need to alter the custom fields for a template from a helper function you can define one in `TemplateUtil` prefixed with `admin`. For example, if your template has a helper function defined as `exampleExtras` you can define an admin helper function in `TemplateUtil` named `adminExampleExtras`. This is useful if you need to inject options for a select list. Admin helper function take two parameters the template data array and `$this->request->data`. The helper function needs to return the modified template data.

### Restricting Templates to Models
In some cases you'd only want certain templates to be selected for certain sections. To do this, you will need to enter the model name in question in to the "Restrict to model" field in the Templates admin. Then, you will need to go to your model and add in the "restrictTo" field to the same model name, eg:

```
	public $actsAs = array(
		'EvTemplates.Template' => array(
			'formInject' => true,
			'restrictTo' => 'BlogPost'
		)
	);
```

This will make only the templates featuring this model name selectable.

### Default Templates
Clicking the "is default" checkbox will make it so that any page in any section will use that template. However, if you wish to restrict this to a specific section, you can enter the model name in the "Restrict to model" field. This way you can define different default templates on a per-section basis.

## Preview Images
As of version 2.0.12.0 the plugin supports preview images of templates. Simply add a preview image on the template (`Images - Preview` tab) and it'll be used as a preview image below the template drop-down selector. You should try and ensure the preview is of a good size as the preview image can be clicked to view a larger version of it.
