<?php
if (! isset($key)):
    $key = 0;
endif;
?>
<div class="clone-row<?php echo (isset($firstRow) && $firstRow) ? ' disabled-row' : ''; ?>">
    <fieldset class="collapsable-fieldset open">
        <legend><?php echo $this->InflectorExt->camelToHumanize($type); ?></legend>
        <div>
            <div class="row">
                <div class="col-xs-12">
                    <div class="legacy-fieldset">
                        <?php
                            echo $this->Form->addField(
                                $blockName . '.' . $key . '.id',
                                array(
                                    'type' => 'hidden',
                                    'class' => 'block-id',
                                    'disabled' => (isset($firstRow) && $firstRow) ? true : false
                                )
                            );

                            $deleteLink = '<a href="" class="delete-item btn btn-sm btn-danger delete-block pull-right text-center"><i class="fa fa-times"></i> Delete Block</a>';

                            echo $this->Form->addField(
                                $blockName . '.' . $key . '.name',
                                array(
                                    'type' => 'string',
                                    'label' => array(
                                        'text' => 'Name',
                                        'class' => 'col-xs-12 col-sm-2 col-md-3 col-lg-2 control-label'
                                    ),
                                    'div' => 'form-group',
                                    'wrapInput' => 'col-xs-12 col-sm-8 col-md-7',
                                    'after' => $deleteLink,
                                    'displayInfo' => 'Will default to main if left blank',
                                    'disabled' => (isset($firstRow) && $firstRow) ? true : false
                                )
                            );

                            echo $this->Form->addField(
                                $blockName . '.' . $key . '.slots',
                                array(
                                    'type' => 'float',
                                    'label' => array(
                                        'text' => 'Slots',
                                        'class' => 'col-xs-12 col-sm-2 col-md-3 col-lg-2 control-label'
                                    ),
                                    'div' => 'form-group',
                                    'min' => -1,
                                    'wrapInput' => 'col-xs-12 col-sm-10 col-md-2',
                                    'disabled' => (isset($firstRow) && $firstRow) ? true : false
                                )
                            );

                            echo $this->Form->addField(
                                $blockName . '.' . $key . '.blockFields',
                                array(
                                    'type' => 'multicheck',
                                    'label' => 'Select Fields',
                                    'div' => 'form-group',
                                    'wrapInput' => 'col-xs-12 col-sm-10 col-md-9',
                                    'options' => $attachmentBlockFields[$blockName],
                                    'disabled' => (isset($firstRow) && $firstRow) ? true : false
                                )
                            );

                            // Image dimension fields
                            if ($type == 'image'):
                                echo $this->Form->addField(
                                    $blockName . '.' . $key . '.image_width',
                                    array(
                                        'label' => array(
                                            'text' => 'Recommended Image Width',
                                            'class' => 'col-xs-12 col-sm-2 col-md-3 col-lg-2 control-label'
                                        ),
                                        'div' => 'form-group',
                                        'type' => 'float',
                                        'min' => -1,
                                        'wrapInput' => 'col-xs-12 col-sm-10 col-md-9',
                                        'disabled' => (isset($firstRow) && $firstRow) ? true : false
                                    )
                                );

                                echo $this->Form->addField(
                                    $blockName . '.' . $key . '.image_height',
                                    array(
                                        'label' => array(
                                            'text' => 'Recommended Image Height',
                                            'class' => 'col-xs-12 col-sm-2 col-md-3 col-lg-2 control-label'
                                        ),
                                        'div' => 'form-group',
                                        'type' => 'float',
                                        'min' => -1,
                                        'wrapInput' => 'col-xs-12 col-sm-10 col-md-9',
                                        'disabled' => (isset($firstRow) && $firstRow) ? true : false,
                                        'displayInfo' => 'Optional. Displays recommended image dimensions to clients.'
                                    )
                                );
                            endif;

                            // manual hidden field so we can added protect-value
                            echo $this->Form->addField(
                                $blockName . '.' . $key . '.is_active',
                                array(
                                    'type' => 'hidden',
                                    'value' => 0,
                                    'class' => 'protect-value',
                                    'id' => '_' . $blockName . '0IsActive',
                                    'disabled' => (isset($firstRow) && $firstRow) ? true : false
                                )
                            );

                            echo $this->Form->addField(
                                $blockName . '.' . $key . '.is_active',
                                array(
                                    'div' => 'form-group',
                                    'type' => 'boolean',
                                    'wrapInput' => 'col-xs-12 col-sm-10 col-md-9 col-md-offset-3 col-lg-10 col-lg-offset-2',
                                    'class' => 'protect-value',
                                    'hiddenField' => false, // turn off so we can manually add one with protect-value class
                                    'disabled' => (isset($firstRow) && $firstRow) ? true : false
                                )
                            );
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </fieldset>
</div>
