<?php

App::uses('EvTemplatesAppModel', 'EvTemplates.Model');

class Template extends EvTemplatesAppModel {

	public $actsAs = array(
		'EvCustomFields.CustomFields' => array(
			'formInject' => true
		)
	);

	public $validate = array(
		'name' => array(
			'notEmpty' => array(
				'rule' => array('notBlank'),
				'message' => 'You must select a name for the template.',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'template' => array(
			'notEmpty' => array(
				'rule' => array('notBlank'),
				'message' => 'You must select a view for the template.',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

	public $hasMany = array(
		'ImageBlock' => array(
			'className' => 'EvTemplates.ImageBlock',
			'cascade' => true,
			'dependent' => true
		),
		'DocumentBlock' => array(
			'className' => 'EvTemplates.DocumentBlock',
			'cascade' => true,
			'dependent' => true
		)
	);

	/**
	 * preview image slot
	 * @var array
	 */
	public $imageSlots = array(
		'preview' => array(
			'slots' => 1,
			'fields' => array()
		)
	);

	/**
	 * redefine the readForEdit to bring out the blocks
	 *
	 * @param int       tempalte id
	 * @param array     extra params for the find
	 */
	public function readForEdit($id, $params = array()) {
		$params['contain'][] = 'ImageBlock';
		$params['contain'][] = 'DocumentBlock';

		return parent::readForEdit(
			$id,
			$params
		);
	}

/**
 * Get all the templates in list format for the items dropdown
 * @param array $restrictTo (Optional) Model name
 * @return array    Array of templates
 */
	public function selectList($restrictTo = array()) {
		$templates = $this->getAvailableTemplates($restrictTo);

		return Hash::combine(
			$templates,
			'{n}.' . $this->alias . '.' . $this->primaryKey,
			'{n}.' . $this->alias . '.' . $this->displayField
		);
	}

/**
 * Get all available templates flagged as active
 * @param array $restrictTo (Optional) Model name
 * @return array Templates
 */
	public function getAvailableTemplates($restrictTo = array()) {
		$params = array(
			'conditions' => array(
				'Template.is_active' => 1
			),
			'order' => 'Template.sequence ASC',
			'callbacks' => false
		);
		if (! empty($restrictTo)) {
			$params['conditions']['Template.model'] = $restrictTo;
		}

		return $this->find('all', $params);
	}

	/**
	 * beforeSave, if nothing entered for the custom field data label, prefill it
	 *
	 * Called before each save operation, after validation. Return a non-true result
	 * to halt the save.
	 *
	 * @param array $options Options passed from Model::save().
	 * @return bool True if the operation should continue, false if it should abort
	 * @link http://book.cakephp.org/2.0/en/models/callback-methods.html#beforesave
	 * @see Model::save()
	 */
	public function beforeSave($options = array()) {
		$return = parent::beforeSave($options);

		if (empty($this->data['Template']['cfDataLabel'])) {
			$this->data['Template']['cfDataLabel'] = 'Custom Data';
		}
		return $return;
	}
}
