<?php

App::uses('AttachmentBlock', 'EvTemplates.Model');

class ImageBlock extends AttachmentBlock {

	/**
	 * redefine the afterFind to pull the image dimensions into a grouped array
	 *
	 */
	public function afterFind($results, $primary = false) {
		$results = parent::afterFind($results, $primary);

		if (! empty($results)) {
			foreach ($results as $key => $item) {
				$results[$key][$this->alias]['dimensions'] = array();

				if (! empty($item[$this->alias]['image_width'])) {
					$results[$key][$this->alias]['dimensions']['width'] = $item[$this->alias]['image_width'];
				}

				if (! empty($item[$this->alias]['image_height'])) {
					$results[$key][$this->alias]['dimensions']['height'] = $item[$this->alias]['image_height'];
				}
			}
		}

		return $results;
	}

}
