<?php

App::uses('BaseMigrationModelUtil', 'EvMigrationUtil.Lib');

class TemplateMigrationModelUtil extends BaseMigrationModelUtil {

/**
 * Exports a page and creates a migration
 *
 * @param string|int $id The id passed on the command line. If an integer it will be used as an ID, if a string it will try to match the name
 * @return bool True on success
 */
	public function getExportMigration($id) {
		$migrationUp = '';
		$migrationDown = '';
		$migration = '';

		$migration .= '$TemplateUtil = MigrationUtil::init(\'EvTemplates.Template\');' . PHP_EOL;
		$migration .= '$CustomFieldUtil = MigrationUtil::init(\'EvCustomFields.Field\');' . PHP_EOL;
		$migration .= '$ImageBlockUtil = MigrationUtil::init(\'EvTemplates.ImageBlock\');' . PHP_EOL;
		$migration .= '$DocumentBlockUtil = MigrationUtil::init(\'EvTemplates.DocumentBlock\');' . PHP_EOL;

		// Fetch the template
		$Template = EvClassRegistry::init('EvTemplates.Template');

		$conditions = [];
		if (is_numeric($id)) {
			$conditions['Template.id'] = $id;
		} else {
			$conditions['Template.name'] = $id;
		}

		$template = $Template->find('first', [
			'conditions' => $conditions,
			'contain' => [
				'ImageBlock',
				'DocumentBlock'
			]
		]);

		$page['Template'] = $template;

		// Remove any ids
		unset(
			$template['Template']['id'],
			$template['Template']['created'],
			$template['Template']['modified']
		);

		// Build the template in the migration
		$migrationUp .= '$templateId = $TemplateUtil->createOnce([' . PHP_EOL;
		$migrationUp .= '	\'name\' => \'' . $template['Template']['name'] . '\',' . PHP_EOL;
		$migrationUp .= '	\'model\' => \'' . $template['Template']['model'] . '\',' . PHP_EOL;
		$migrationUp .= '], [' . PHP_EOL;
		foreach ($template['Template'] as $field => $value) {
			$migrationUp .= '	\'' . $field . '\' => ' . $this->_migrationValue($value) . ',' . PHP_EOL;
		}
		$migrationUp .= ']);' . PHP_EOL;

		// Create the custom fields
		if (!empty($template['CustomFields'])) {
			$migrationUp .= '$customFieldIds = $CustomFieldUtil->createAllOnce([\'name\', \'model\', \'model_id\'], [' . PHP_EOL;
			foreach ($template['CustomFields'] as $customField) {
				$migrationUp .= '	' . $customField['Field']['id'] . ' => [' . PHP_EOL;

				unset(
					$customField['Field']['id'],
					$customField['Field']['model_id'],
					$customField['Field']['created'],
					$customField['Field']['modified']
				);

				foreach ($customField['Field'] as $field => $value) {
					$migrationUp .= '		\'' . $field . '\' => ' . $this->_migrationValue($value) . ',' . PHP_EOL;
				}

				$migrationUp .= '		\'model_id\' => $templateId,' . PHP_EOL;
				$migrationUp .= '	],' . PHP_EOL;
			}
			$migrationUp .= ']);' . PHP_EOL;
		}

		// Copy any image blocks
		if (!empty($template['ImageBlock'])) {
			$migrationUp .= '$ImageBlockUtil->createAllOnce([\'template_id\', \'name\'], [' . PHP_EOL;
			foreach ($template['ImageBlock'] as $imageBlock) {

				$blockFields = json_encode($imageBlock['blockFields']);
				unset(
					$imageBlock['id'],
					$imageBlock['created'],
					$imageBlock['modified'],
					$imageBlock['template_id'],
					$imageBlock['dimensions'],
					$imageBlock['blockFields']
				);

				$migrationUp .= '	[' . PHP_EOL;
				foreach ($imageBlock as $field => $value) {
					$migrationUp .= '		\'' . $field . '\' => ' . $this->_migrationValue($value) . ',' . PHP_EOL;
				}
				$migrationUp .= '		\'template_id\' => $templateId,' . PHP_EOL;
				$migrationUp .= '		\'blockFields\' => ' . $blockFields . ',' . PHP_EOL;
				$migrationUp .= '	],' . PHP_EOL;
			}
			$migrationUp .= ']);' . PHP_EOL;
		}

		// Copy any document blocks
		if (!empty($template['DocumentBlock'])) {
			$migrationUp .= '$DocumentBlockUtil->createAllOnce([\'template_id\', \'name\'], [' . PHP_EOL;
			foreach ($template['DocumentBlock'] as $documentBlock) {

				$blockFields = json_encode($documentBlock['blockFields']);
				unset(
					$documentBlock['id'],
					$documentBlock['created'],
					$documentBlock['modified'],
					$documentBlock['template_id'],
					$documentBlock['blockFields']
				);

				$migrationUp .= '	[' . PHP_EOL;
				foreach ($documentBlock as $field => $value) {
					$migrationUp .= '		\'' . $field . '\' => ' . $this->_migrationValue($value) . ',' . PHP_EOL;
				}
				$migrationUp .= '		\'template_id\' => $templateId,' . PHP_EOL;
				$migrationUp .= '		\'blockFields\' => ' . $blockFields . ',' . PHP_EOL;
				$migrationUp .= '	],' . PHP_EOL;
			}
			$migrationUp .= ']);' . PHP_EOL;
		}

	/**
	 * Down
	 */

		$migrationDown .= '$templateId = $TemplateUtil->Model->field(\'Template.id\', [\'Template.name\' => \'' . $template['Template']['name'] . '\', \'Template.model\' => \'' . $template['Template']['model'] . '\']);' . PHP_EOL;
		$migrationDown .= '$TemplateUtil->Model->ImageBlock->deleteAll([\'ImageBlock.template_id\' => $templateId]);' . PHP_EOL;
		$migrationDown .= '$TemplateUtil->Model->DocumentBlock->deleteAll([\'DocumentBlock.template_id\' => $templateId]);' . PHP_EOL;
		$migrationDown .= '$CustomFieldUtil->deleteAll([\'Field.model\' => \'EvTemplates.Template\', \'Field.model_id\' => $templateId]);' . PHP_EOL;
		$migrationDown .= '$TemplateUtil->Model->delete($templateId);' . PHP_EOL;

		return [
			'common' => $migration,
			'up' => $migrationUp,
			'down' => $migrationDown
		];
	}

}
