<?php

/**
 * base template utility to setup the controller object
 * can be also used for storing common functionality in the future
 *
 */
class BaseTemplateUtil {

	/**
	 * the controller object from which the
	 * template component will have been called from
	 */
	protected $_controller = null;

	/**
	 * constructor
	 *
	 * setup and store the controller passed in from the component
	 *
	 * @param   Object  Controller object
	 */
	public function __construct($Controller) {
		if (! is_object($Controller)) {
			throw new InvalidArgumentException('TemplateUtil is expecting a valid Controller Object From TPL Component');
		}

		$this->_controller = $Controller;
	}
}
