<?php

App::uses('AppComponent', 'Controller/Component');
App::uses('TemplateUtil', 'Lib');

class TplComponent extends AppComponent {

	/**
	 * variable to store any data from template helper
	 */
	protected $_helperData;

	/**
	 * given the item data, get the template info (view / helper method etc...)
	 * Template ID will be stored on the model, we try and work it out from the controller the component is run on
	 * Will provide the override option incase it's different
	 *
	 * @param   array        Data array from a models readForView or a general find method
	 * @param   string       Model alias to use to find the template_id
	 * @return  string|bool  Template file to use, set to $this->view or false if we can't find the info
	 */
	public function getTemplate($data, $modelAlias = null) {
		if ($modelAlias === null) {
			$Model = $this->_controller->{$this->_controller->modelClass};
			$modelAlias = $Model->alias;
		}

		if (empty($data[$modelAlias]['template_id'])) {
			return false;
		}

		$templateId = $data[$modelAlias]['template_id'];

		$Template = EvClassRegistry::init('EvTemplates.Template');
		$templateData = $Template->readForView($templateId);

		if (empty($templateData['Template']['template'])) {
			return false;
		}

		$this->handleHelper($templateData['Template']['helperFunction'], $data);

		return $templateData['Template']['template'];
	}

	/**
	 * handle the processing of the helper method
	 *
	 * @param   string      The helper method to use
	 * @param   array       Array of data passed to getTemplate
	 * @return  bool
	 */
	public function handleHelper($helper, $data) {
		$TemplateUtil = new TemplateUtil($this->_controller);

		if (empty($helper) || ! method_exists($TemplateUtil, $helper)) {
			return false;
		}

		$this->_helperData = $TemplateUtil->$helper($data);

		return true;
	}

	/**
	 * get and return the helper data
	 *
	 * @return  mixed
	 */
	public function getHelperData() {
		return $this->_helperData;
	}
}
