<?php

App::uses('AppComponent', 'Controller/Component');
App::uses('TemplateUtil', 'Lib');

class TemplateComponent extends AppComponent {

	/**
	 * run the form injection
	 * For custom fields this add type / validation arrays to the template for fields
	 *
	 * @param   array       Data from $this->request->data
	 * @param   object      Model Object for the primary model we are dealing with
	 * @param   int|null    The ID if on edit or null of add
	 */
	public function injectAdminForm($data, $Model, $id) {
		// get all the templates for the Form
		$Template = EvClassRegistry::init('EvTemplates.Template');

		$this->_controller->viewVars['fields'][$Model->alias . '.template_id']['class'] = 'ev-templates-template-selector';

		$restrictTo = array();

		// Check the model to see if we're wanting to only show templates that are assigned to specific models.
		if (isset($Model->actsAs['Template']['restrictTo']) && ! empty($Model->actsAs['Template']['restrictTo'])) {
			$restrictTo = $Model->actsAs['Template']['restrictTo'];
		}

		$templates = $Template->getAvailableTemplates($restrictTo);
		$this->_controller->set('templates', Hash::combine($templates, '{n}.Template.id', '{n}.Template.name'));
		// Check if we've got a template flagged as 'default' and assign the first one to the
		// request data.
		// Look for model-based templates first
		$defaultTemplates = array_filter(Hash::combine(
			$templates,
			'{n}.Template[is_default=1][model=/^' . $Model->alias . '$/].id',
			'{n}.Template[is_default=1][model=/^' . $Model->alias . '$/].is_default'
		));

		// If there's no model-based templates, look for global ones
		if (empty($defaultTemplates)) {
			$defaultTemplates = array_filter(
				Hash::combine($templates, '{n}.Template[model=/^$/].id', '{n}.Template[model=/^$/].is_default')
			);
		}

		if (! empty($defaultTemplates) && empty($this->_controller->request->data[$Model->alias]['template_id'])) {
			$this->_controller->request->data[$Model->alias]['template_id'] = key($defaultTemplates);
		}
		// If we've got only one available template and it is flagged as default or we have no
		// templates then we want to hide the templates drop-down. We hide the containing div so
		// that the JavaScript listener can still fire and load the Custom Data tab.
		if (count($templates) === 1 && ! empty($defaultTemplates) || empty($templates)) {
			if (
				! empty($Model->alias) &&
				! empty($this->_controller->viewVars['fields'][$Model->alias . '.template_id'])
			) {
				$this->_controller->viewVars['fields'][$Model->alias . '.template_id']['div'] = 'hidden';
			}
		}
	}
}
