<?php

App::uses('EvTeamAppModel', 'EvTeam.Model');

/**
 * Business rules for Pages
 */
class TeamMember extends EvTeamAppModel {

	public $displayField = 'name';

	public $actsAs = [
		'EvTemplates.Template' => [
			'formInject' => true
		],
		'Routable.Routable' => [
			'config' => 'EvTeam',
			'alias' => 'our-team/:displayField',
		],
		'MetaData.Meta'
	];

	public $validate = [
		'name' => [
			'required' => [
				'rule' => 'notBlank',
				'message' => 'Please add a name'
			]
		],
	];

	public $imageSlots = [
		'main' => [
			'slots' => 1,
			'fields' => [
				'alt'
			]
		],
	];

	public $hasAndBelongsToMany = [
		'Department' => [
			'className' => 'EvTeam.Department',
			'joinTable' => 'ev_team_departments_team_members'
		]
	];

	/**
	 * Method to get TeamMembers within a department.
	 * @param   $departmentId 	Pass this is in to get the team for the
	 *                          current department only.
	 * @return   array
	 */
	public function getTeam($departmentId = null) {
		$alias = $this->alias;

		$team = $this->find('all',
			[
				'conditions' => [
					"$alias.is_active" => 1,
					'DepartmentTeamMember.department_id' => $departmentId
				],
				'joins' => [
					[
						'table' => 'ev_team_departments_team_members',
						'alias' => 'DepartmentTeamMember',
						'type' => 'LEFT',
						'conditions' => [
							"DepartmentTeamMember.team_member_id = $alias.id"
						]
					]
				],
				'contain' => [
					'Image'
				],
				'order' => ["$alias.sequence ASC", "$alias.name ASC"],
			]
		);
		return $team;
	}

	/**
	 * Method to return any featured teamMembers in a random order. Not used in the plugin,
	 * but useful if you need it for your own project. Just call TeamMember->getFeatured();
	 * @return   array
	 */
	public function getFeatured() {
		return $this->find('all',
			[
				'conditions' => [
					"$alias.is_featured" => 1,
					"$alias.is_active" => 1,
				],
				'contain' => 'Image',
				'order' => 'RAND()'
			]
		);
	}

}
