<?php

App::uses('EvTeamAppModel', 'EvTeam.Model');

/**
 * Business rules for Pages
 */
class Department extends EvTeamAppModel {

	public $displayField = 'title';

	public $actsAs = [
		'Routable.Routable' => [
			'config' => 'EvTeam',
			'alias' => 'team-departments/:displayField',
		],
		'MetaData.Meta'
	];

	public $validate = [
		'title' => [
			'required' => [
				'rule' => 'notBlank',
				'message' => 'cannot be blank'
			]
		],
	];

	public $hasAndBelongsToMany = [
		'TeamMember' => [
			'className' => 'EvTeam.TeamMember',
			'joinTable' => 'ev_team_departments_team_members'
		]
	];
}
