<?php

App::uses('EvTeamAppController', 'EvTeam.Controller');

App::uses('ArrayUtil', 'Lib');

class TeamMembersController extends EvTeamAppController {

	protected function _adminFormFields() {
		$Model = $this->{$this->modelClass};
		$alias = $Model->alias;

		$fields = parent::_adminFormFields();

		if (isset($fields["$alias.position"])) {
			$fields["$alias.position"]['label'] = 'Job Title';
		}

		if (Configure::read('EvTeam.enable_departments')) {
			// Get a department Id for a team member
			$departmentId = 0;
			if (!empty($this->request->data['TeamMember'])) {
				$params = [
					'contain' => [
						'Department'
					]
				];
				$id = $this->request->data['TeamMember']['id'];
				$currentDepartment = $Model->readForView($id, $params);
				$departmentId = !empty($currentDepartment['Department'][0]) ? $currentDepartment['Department'][0]['id'] : 0;
			}
			$fields['Department'] = [
				'label' => 'Departments',
				'type' => 'select',
				'value' => $departmentId,
			];
		}

		return $fields;
	}

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(
			[
				'index',
				'view'
			]
		);
	}

	protected function _adminPopulateLookups() {
		$Model = $this->{$this->modelClass};
		$alias = $Model->Department->alias;

		$departments = $Model->Department->find('list',
			[
				'conditions' => [
					"$alias.is_active" => 1
				]
			]
		);
		$this->set(compact('departments'));
	}

	public function index() {
		$Model = $this->{$this->modelClass};
		$alias = $Model->alias;

		$params = [
			'contain' => [
				'Department'
			],
			'order' => ["$alias.sequence ASC", "$alias.name ASC"]
		];

		$teamMembers = $Model->readForIndex($params);
		$departments = $Model->Department->readForIndex();
		$currentDepartment = null;
		$this->set(compact('teamMembers', 'departments', 'currentDepartment'));

		$this->assignPage('STAFF', 'page');
	}

	public function view($id) {
		$Model = $this->{$this->modelClass};

		$params = [
			'contain' => [
				'Department'
			]
		];

		$data = $Model->readForView($id, $params);
		if (empty($data)) {
			throw new NotFoundException();
		}

		$departments = [];
		$currentDepartment = [];

		if (Configure::read('EvTeam.enable_departments')) {
			$departments = $Model->Department->readForIndex();

			if (!empty($data['Department'])) {
				$currentDepartment = reset($data['Department']);
			}
		}

		$this->Meta->set($data);

		$this->set(compact('data', 'departments', 'currentDepartment'));

		//Preparing plugin for templates.
		if ($Model->hasBehavior('EvTemplates.Template')) {
			$this->view = $this->Tpl->getTemplate($data);
		}
		if (!$this->view) {
			$this->view = 'EvTeam.TeamMembers/view';
		}
	}
}
