<?php

App::uses('EvTeamAppController', 'EvTeam.Controller');

class DepartmentsController extends EvTeamAppController {

	public function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow(
			[
				'view'
			]
		);
	}

	public function view($id) {
		$Model = $this->{$this->modelClass};
		$alias = $Model->alias;

		$currentDepartment = $Model->readForView($id);
		$departments = $Model->readForIndex();
		$this->Meta->set($currentDepartment);

		$this->set('page', $currentDepartment[$alias]);
		$this->set('departments', $departments);
		$this->set('currentDepartment', $currentDepartment['Department']);
		$this->set('teamMembers', $Model->TeamMember->getTeam($id));

		$this->view = 'EvTeam.TeamMembers/index';
	}
}