<?php
class AddedForeignKeyRelationsToTheLinkTable extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'added_foreign_key_relations_to_the_link_table';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'alter_field' => array(
				'ev_team_departments_team_members' => array(
					'department_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'index'),
					'team_member_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'index'),
				),
			),
			'create_field' => array(
				'ev_team_departments_team_members' => array(
					'indexes' => array(
						'department_id' => array('column' => 'department_id', 'unique' => 0),
						'team_member_id' => array('column' => 'team_member_id', 'unique' => 0),
					),
				),
			),
		),
		'down' => array(
			'alter_field' => array(
				'ev_team_departments_team_members' => array(
					'department_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false),
					'team_member_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false),
				),
			),
			'drop_field' => array(
				'ev_team_departments_team_members' => array('indexes' => array('department_id', 'team_member_id')),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
