# EvTax

## Installation

Simply add EvTax to the `install.php` file within the Config directory and run `Console/cake installer core` once you have added all the other plugins you will need.

If this has already been run, simply run `Console/cake installer plugin EvTax`.

The installer will automatically setup the database tables and add the link to create new tax rules to the admin menu.

## How it works

The tax plugin has 3 main parts to it, first one is inbuilt in the plugin which is the admin section that allows you to setup tax rules by specifying a name for it and the percentage amount of the tax.

The second is in the form of a behavior which are attached to a model which becomes the model that links to the tax rule. This model **MUST** have a `tax_level_id` column on it. This part is responsible for selecting which tax level it belongs to. In the case of `EvShop`, this is the Product Model.

The third part is in the form of a behavior which is attached to a model and this becomes the model which has the currency / price fields which need to have tax calculated on. When querying on this model, the behavior with then return the prices fields ex. Tax and inc. Tax. The inc. Tax fields will simply be the matching fields name with '_incTax' appended to the end. 

E.G. price (ex tax) -> price_incTax // sale_price -> sale_price_incTax

In the case of `EvShop`, this part is handled by the Variant Model.

While in the case of `EvShop` the second and third parts are separate models, in another situation they could both be applied to the same model and have it all work as normal.

## Setup

Setup is relatively simple, running the installer will setup all the tables then simply set the behaviors on the required models.

### TaxableBehavior

This behavior defines which model links to the tax rule. This model **MUST** have a `tax_level_id` column attached to it. When setting this behavior up, you will need to set the `formInject` setting to `true` in order to help setup the admin section for this. In this case, it's simply a component which automatically retrieves the tax levels and sets them in CakePHPs form data standard allowing the scaffolding to automatically populate the `tax_level_id` field with the available Tax Levels.

The following example is from `EvShop` and shows the Product model checking if EvTax is loaded before loading the TaxableBehavior.

	public function __construct($id = false, $table = null, $ds = null) {
		if (CakePlugin::loaded('EvTax')) {
			$this->actsAs['EvTax.Taxable'] = array(
				'formInject' => true
			);
		}

		parent::__construct($id, $table, $ds);
	}

### CalculateTaxBehavior

This behavior defines the model which contains the currency / price fields and which fields they are. When using this behavior, the taxed values will automatically be retrieved when doing a find on the parent model. Disable find callbacks to prevent the calculations happening.

If you are attaching both behaviors to the same Model, the setup for this Behavior is a lot simpler. In this instance you only need to attach the behavior and define which fields should be taxed.

	$this->actsAs['EvTax.CalculateTax'] = [
		'fields' => [
			'price',
			'sale_price',
			'some_other_price'
		]
	];
	
If you are using the behaviors on two different models, like in the case of `EvShop`, some extra config and setup is needed. When setting up the `actsAs`, you need to define the model which holds the `TaxableBehavior` and the foreign key needed to link to that model.

The following example is taken from the Variant model of `EvShop`.

	$this->actsAs['EvTax.CalculateTax'] = [
		'fields' => [
			'rrp',
			'price',
			'sale_price'
		],
		'TaxRateModel' => 'EvShop.Product',
		'TaxRateModelId' => 'Variant.product_id'
	];
	
When trying to calculate the tax amount for each field, the `CalculateTaxBehavior` will use the information to contact the other model and run the method `getTaxRate()` to retrieve the rate. This method is part of the `TaxableBehavior` so by attaching to a model it makes this method available to the model. However for any reason, you should be able to create your own `getTaxRate()` method on the model to override the functionality if required.

###Multi-Currency Support
As of version 2.2.0.0 EvTax runs on the multi-currency system and required EvCurrency to function. Essentially the only impact this has on the EvTax plugin is a currency_id field.

## Extending

Generally with what this plugin does and how it's setup, there is unlikely to be much need for extending or overriding the functionality. However, should it be required the behaviors can be overridden using the available functionality bundled now with Core. Documentation for this can be found at <https://evoluted.kilnhg.com/Code/Repositories/Evoluted-Core/core-docs/Files/Features/Behaviours/index.md?rev=master>

## Events

There are no events trigger throughout this plugin.



