<?php
/**
 * EvTaxTaxLevelFixture
 *
 */
class TaxLevelFixture extends CakeTestFixture {

	public $table = 'ev_tax_tax_levels';

/**
 * Fields
 *
 * @var array
 */
	public $fields = array(
		'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'primary'),
		'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
		'rate' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '6,2', 'unsigned' => false),
		'is_active' => array('type' => 'boolean', 'null' => true, 'default' => '0'),
		'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'indexes' => array(
			'PRIMARY' => array('column' => 'id', 'unique' => 1)
		),
		'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB')
	);

/**
 * Records
 *
 * @var array
 */
	public $records = array(
		array(
			'id' => 1,
			'name' => 'Tax Exempt',
			'rate' => '0.00',
			'is_active' => 1,
			'created' => '2015-07-20 16:14:47',
			'modified' => '2015-07-20 16:14:47'
		),
		array(
			'id' => 2,
			'name' => 'UK VAT',
			'rate' => '20.00',
			'is_active' => 1,
			'created' => '2015-07-20 16:14:47',
			'modified' => '2015-07-20 16:14:47'
		),
	);

}
