<?php

App::uses('EvTaxAppModel', 'EvTax.Model');

class TestModel extends EvTaxAppModel {
}

class TaxableBehaviorTest extends CakeTestCase {

	/**
	 * Fixtures
	 *
	 * @var array
	 */
	public $fixtures = array(
		'plugin.EvTax.tax_level',
		'plugin.EvTax.test_model'
	);

	/**
	 * setUp method
	 *
	 * @return void
	 */
	public function setUp() {
		parent::setUp();

		$this->Model = EvClassRegistry::init('TestModel');
		$this->Model->addBehavior('EvTax.Taxable');
	}

	/**
	 * tearDown method
	 *
	 * @return void
	 */
	public function tearDown() {
		parent::tearDown();

		unset($this->Model);
	}

	public function testGetTaxRateReturnsValidTaxRate() {
		$this->assertEquals(
			20.00,
			$this->Model->Behaviors->Taxable->getTaxRate($this->Model, 1)
		);
	}

	public function testGetTaxRateReturnsValidZeroTaxRate() {
		$this->assertEquals(
			0.00,
			$this->Model->Behaviors->Taxable->getTaxRate($this->Model, 2)
		);
	}

	public function testGetTaxRateReturnsFalseWhenQueryingOnInvalidRow() {
		$this->assertFalse(
			$this->Model->Behaviors->Taxable->getTaxRate($this->Model, 99999)
		);
	}
}
