<?php

App::uses('EvTaxAppModel', 'EvTax.Model');

class TestModel extends EvTaxAppModel {
}

class TestModel2 extends EvTaxAppModel {
}

class CalculateTaxBehaviorTest extends CakeTestCase {

	/**
	 * Fixtures
	 *
	 * @var array
	 */
	public $fixtures = array(
		'plugin.EvTax.tax_level',
		'plugin.EvTax.test_model',
		'plugin.EvTax.test_model2'
	);

	/**
	 * setUp method
	 *
	 * @return void
	 */
	public function setUp() {
		parent::setUp();

		$this->Model = EvClassRegistry::init('TestModel');
		$this->Model->addBehavior(
			'EvTax.Taxable'
		);
		$this->Model->addBehavior(
			'EvTax.CalculateTax',
			array(
				'fields' => array(
					'price'
				)
			)
		);

		$this->Model2 = EvClassRegistry::init('TestModel2');
		$this->Model2->addBehavior(
			'EvTax.CalculateTax',
			array(
				'fields' => array(
					'price'
				),
				'TaxRateModel' => 'TestModel',
				'TaxRateModelId' => 'TestModel2.test_model_id'
			)
		);
	}

	/**
	 * tearDown method
	 *
	 * @return void
	 */
	public function tearDown() {
		parent::tearDown();

		unset($this->Model);
		unset($this->Model2);
	}

	public function testAfterFindsSetupAndSetValueIncVatOnSameModel() {
		$this->assertEquals(
			array(
				'TestModel' => array(
					'id' => '1',
					'name' => 'A Test Record',
					'tax_level_id' => '2',
					'price' => '10.000000',
					'created' => '2015-07-20 16:14:47',
					'modified' => '2015-07-20 16:14:47',
					'price_incTax' => '12.000000',
				),
				'TaxLevel' => array(
					'id' => '2',
					'name' => 'UK VAT',
					'rate' => '20.00',
					'is_active' => true,
					'created' => '2015-07-20 16:14:47',
					'modified' => '2015-07-20 16:14:47'
				)
			),
			$this->Model->find(
				'first',
				array(
					'conditions' => array(
						'TestModel.id' => 1
					)
				)
			)
		);
	}

	public function testAfterFindsSetupAndSetValueIncVatOnDifferentModel() {
		$this->assertEquals(
			array(
				'TestModel2' => array(
					'id' => '3',
					'name' => 'A Third Test Record',
					'test_model_id' => '1',
					'price' => '10.500000',
					'created' => '2015-07-20 16:14:47',
					'modified' => '2015-07-20 16:14:47',
					'price_incTax' => '12.600000'
				)
			),
			$this->Model2->find(
				'first',
				array(
					'conditions' => array(
						'TestModel2.id' => 3
					)
				)
			)
		);
	}
}