<?php

App::uses('AppBehavior', 'Model/Behavior');

class TaxableBehavior extends AppBehavior {

/**
 * Link the model that has this behavior with the tax levels model so we can contain data.
 *
 * @param Model $Model The model that called this behavior.
 * @return void.
 */
	public function linkTaxable(Model $Model) {
		$Model->bindModel(
			array(
				'belongsTo' => array(
					'TaxLevel' => array(
						'className' => 'EvTax.TaxLevel'
					)
				)
			),
			false
		);
	}

/**
 * Get a tax rate from an model that is associated with a tax level.
 *
 * @param Model $Model  Model object auto populated by CakeORM.
 * @param int   $itemId The id of the item to get a tax rate for.
 * @return decimal|bool Tax Rate or bool false if not found
 */
	public function getTaxRate($Model, $itemId) {
		$this->linkTaxable($Model);

		$modelTable = !empty($Model->tablePrefix) ? $Model->tablePrefix : '';
		$modelTable .= $Model->table;

		$data = $Model->TaxLevel->find(
			'first',
			array(
				'joins' => array(
					array(
						'table' => $modelTable,
						'alias' => $Model->alias,
						'conditions' => [
							$Model->alias . '.' . $Model->primaryKey => $itemId,
							$Model->TaxLevel->alias . '.' . $Model->TaxLevel->primaryKey . ' = ' . $Model->alias . '.tax_level_id',
						],
					),
				),
			)
		);

		if (!empty($data[$Model->TaxLevel->alias]['rate'])) {
			return $data[$Model->TaxLevel->alias]['rate'];
		}

		return false;
	}
}
