$(function() {
	const form = document.getElementById('stripe-payment-form');

	const formElements = {
		'form': form,
		'cardholderName': document.getElementById('PaymentCardName'),
		'cardButton': document.getElementById('card-button'),
		'paymentMethod': document.getElementById('PaymentMethodId'),
	}

	// Add stripe.js elements to the page
	const elements = stripe.elements();
	const card = elements.create('cardNumber');
	card.mount('#cardNumber');
	const cardExpiry = elements.create('cardExpiry');
	cardExpiry.mount('#cardExpiry');
	const cardCvc = elements.create('cardCvc');
	cardCvc.mount('#cardCvc');

	form.addEventListener('submit', function(event) {
		event.preventDefault();
		if (validate(form) === true) {
			// Disable the submit button to prevent repeated clicks:
			$(':submit', form).prop('disabled', true);
			// Remove old Stripe error message.
			$('.js-stripe-payment-errors div').remove();

			// Request a token from Stripe:
			createToken(form, card);
			createPayment(formElements, card);

			// Prevent the form from being submitted:
			return false;
		}
		$(':submit', form).prop('disabled', false);
	});

});

/**
 * Get a token from stripe's API
 */
function createToken(form, card) {
	stripe.createToken(card).then(function (result) {
		if (result.error) {
			// Inform the user if there was an error
			const errorElement = document.getElementById('card-errors');
			errorElement.textContent = result.error.message;
			$(':submit', form).prop('disabled', false);
		} else {
			// Send the token to your server
			stripeTokenHandler(result.token);
		}
	});
}

/**
 * Insert the token ID into the form so it gets submitted to the server
 */
function stripeTokenHandler(token) {
	const form = document.getElementById('stripe-payment-form');
	const hiddenInput = document.createElement('input');
	hiddenInput.setAttribute('type', 'hidden');
	hiddenInput.setAttribute('name', 'stripeToken');
	hiddenInput.setAttribute('id', 'stripeToken');
	hiddenInput.setAttribute('value', token.id);
	form.appendChild(hiddenInput);
}

function createPayment(formElements, card) {
	stripe.createPaymentMethod('card', card, {
		billing_details: {name: formElements.cardholderName.value}
	}).then(function (result) {
		if (result.error) {
			// Show error in payment form
			const errorElement = document.getElementById('card-errors');
			errorElement.textContent = result.error.message;
			$(':submit', formElements.form).prop('disabled', false);
		} else {
			formElements.paymentMethod.value = result.paymentMethod.id;
			formElements.form.submit();
		}
	});
}

function validate() {
	// Copy this file to app/webroot/js and add your own validation here
	const $form = $('#stripe-payment-form');
	return !$form.find('input, div').hasClass(errorClass);
}
