/* global stripe, $, console */
var paymentButton  = $('#payment-request-button');

var defaultPaymentRequestParameters = {
	country: 'GB',
	currency: 'gbp',
	requestPayerName: true,
	requestPayerEmail: true,
	total: buildPaymentRequestTotal(),
};

var paymentRequest = stripe.paymentRequest(defaultPaymentRequestParameters);
var elements 	   = stripe.elements();

var prButton = elements.create('paymentRequestButton', {
	paymentRequest: paymentRequest,
	style: {
		paymentRequestButton: {
			type: 'default', //'default' | 'donate' | 'buy', // default: 'default'
			theme: 'dark', //'dark' | 'light' | 'light-outline', // default: 'dark'
			height: '40px', // default: '40px', the width is always '100%'
		},
	},
});

prButton.on('click', function(ev) {
	paymentRequest.update({total: buildPaymentRequestTotal()});
});

function buildPaymentRequestTotal() {
	return {
		label: paymentButton.attr('data-title'),
		amount: parseInt(paymentButton.attr('data-price')),
	};
}

// Check the availability of the Payment Request API first.
paymentRequest.canMakePayment().then(function(result) {
	if (result) {
		prButton.mount('#payment-request-button');
	} else {
		var defaultPayment = $('#pay-with-card');

		if (paymentButton.parent().hasClass("col-sm-6")) {
			$('#payment-request-button').parent().remove(); 
			if (defaultPayment && defaultPayment.hasClass("col-sm-6")) {

				defaultPayment.attr('class', 'col-xs-12')
					.parent().addClass('text-right');
			}
		} else {
			paymentButton.remove();
		}
		
	}
});

paymentRequest.on('token', function (ev) {
	// Send the token to your server to charge it!
	var $form = $('.form-checkout');
	$form.append($('<input type="hidden" name="data[stripeToken]">').val(ev.token.id));

	fetch(window.location.href, {
		method: 'POST',
		redirect: "follow",
		credentials: "same-origin",
		body: $form.serializeJSON(),
		headers: {
            "Content-Type": "application/json; charset=utf-8",
            "X-Requested-With": "XMLHttpRequest" // This is how CakePHP detirmines it is an AJAX request
        },
	}).then(function(response) {
		if (response.ok) {
			// If the response is redirected then we assume it was redirected to the success page and redirect the user
			if (response.redirected) {
				ev.complete('success');
				window.location.href = response.url;
			} else {
				// If it was not a redirect try and parse for JSON to see if it was ok or not 
				response.text().then(function(text) {
					json = JSON.parse(text);
					
					if (json.success) {
						ev.complete('success');
					} else {
						ev.complete('fail');
					}

					window.location.href = json.url;
				})
			}
		} else {
			ev.complete('fail');
			window.location.href = response.url;
		}
	}).catch(function(error) {
        ev.complete('fail');
    });
});
