# EvStripe

Plugin for taking Stripe payments using EvTransactions.

Usage
-----

## Stripe Checkout (Off-site & SCA Ready)

In prior versions we've used the deprecated Stripe payment modal, which used to be known as Checkout. This is no longer supported and should not be used, as it doesn't meet the stricter 3D Secure V2 standards, and as such will fail more and more payments until version 2 becomes a requirement (expected in 2022).

The implementation of the original checkout has been left in place, and untouched as many sites do still rely on it.

A replacement which uses the officially named 'Stripe Checkout' has been added. This works by pushing the user off site to the Stripe hosted checkout flow, which is able to handle Credit Card, Apple Pay, Google Pay, Klarna, etc without having to make any site changes.


### Integration
Implementing Checkout into our CakePHP sites is fairly trivial and not really any different from other EvTransaction plugins.

In your EvTransaction config file set the payment gateway to `EvStripe.StripeCheckout`. An array called `stripe` should also be provided containing `dev` and `live` credentials. Your config file should look something like this:

```php
$config = [
	'EvTransactions' => [
		'skipGatewayOnLocal' => false, // Set this to true to fake payments on your local environment, instead of handing off to the gateway plugin
		'skipGatewayOnDev' => false, // Set this to true to fake payments on your dev/staging environment, instead of handing off to the gateway plugin

		'gateway' => 'EvStripe.StripeCheckout',
		'currency' => 'gbp',
		'stripe' => [
			'live' => [
				'secret_key' => 'sk_live_ultAFx106PN9yLWgexDJdElr00DRlr00jS',
				'publishable_key' => 'pk_live_Nmj6YCWon2mRE9TTKn771o3o00m0HvxxJ5',
			],
			'dev' => [
				'secret_key' => 'sk_test_I13Zuph2RjxWpybZ7jBJhV0y00mY5R8hBI',
				'publishable_key' => 'pk_test_OYzx6Qi28t8QLHaemeUh5OWq00CMQZ0m9H',
			],
		],
	],
];
```


In your data that you send to the EvTransaction `takePayment` method you need to provide two return urls in an array, like so:

```php
$return = [
	'return' => 'https://yoursite.com/complete?transaction=123',
	'cancel' => 'https://yoursite.com/checkout',
];
```

Note the transaction parameter - this is the EvTransaction Transaction database record id. When Stripe redirects back to your completed page you can call EvTransaction `checkPayment` method as usual - this will return a payment status, the same way every other EvTransaction payment type does, and it'll handle updating the transaction record with the completed (or failed) payment.

### Additional Notes
This change was done in early 2022 for UKBungee and Segway to meet the SCA rules. Those sites have multiple checkouts (one for bookings, one for vouchers), but follow the same flow as any EvCheckout based site, so can be used as a reference to see how this works.

#### Branding
You can customise the checkout branding from the clients Stripe account. As of writing it gives you options to set a primary and secondary colour, as well as upload a logo and icon.

#### Omnipay Support
Sadly the Stripe Omnipay package has become slightly neglected. They added support for Stripe Checkout in 2021, however failed to update their documentation, or even tag the release. Because of this the composer.json is having to use a specific commit hash to ensure it brings in the Stripe Checkout package. Should they tag the release this can be updated.


## Old Stripe Checkout (Deprecated)


When using Stripe all card data is submitted directly to the payment gateway and not via the website's server. This is handled using some JavaScript supplied by Stripe that generates a token that is then submitted to the website's server for processing the payment. So on your payment page you need to include the JS which is done using the `stripejs` element:-

	<?= $this->element('EvStripe.stripejs') ?>

If you want to customise the script for handling the communication between the website and Stripe
then override the `webroot/js/stripe.js` file.

Make sure you also load the Stripe component in your controller so that the Stripe JS is set up with the correct key:-

	$this->loadComponent('EvStripe.Stripe');

An example payment form has been included that can be used directly or just as a guide. This can be found in `View/Elements/payment_form.ctp`. It's important that the form inputs aren't named so that they don't submit card details to the server and that they use the `data-stripe` attributes.

You will need to configure the plugin in `Config/Plugin/ev_transactions.php` and it should look something like:-

	$config = [
		'EvTransactions' => [
			'gateway' => 'EvStripe.Stripe',
			'currency' => 'gbp',
			'stripe' => [
				'live' => [
					'secret_key' => 'to-be-provided-by-client',
					'publishable_key' => 'to-be-provided-by-client'
				],
				'dev' => [
					'secret_key' => 'sk_test_5Z0SK51oEvPlaRkh6wKFJ7Gu',
					'publishable_key' => 'pk_test_oTLrM7uYObyZd3BtBIX61mg1'
				]
			]
		]
	];

When you take payment using EvTransactions' `Transactions::takePayment()` it will return the payment response to determine if successful payment has been taken or not rather than `processReturn()`.

This plugin uses OmniPay.


Stripe has a JavaScript popover form that can be used for payments. This exists as a basic element at `View/Elements/stripe_checkout.ctp`:

	<?= $this->element('EvStripe.stripe_checkout') ?>

This element is set to output a `<script>` element inside a `<form>` tag which will POST to the page it's on. All the script does is render a `<button>` so you will your own HTML wrappers. The rendered button has the class `stripe-button-el`.

Please note that you do not need to include the other elements (payment_form, stripejs)

You will need to create the "checkout" settings array inside your EvTransactions > Stripe config:

	$config = [
		'EvTransactions' => [
			'gateway' => 'EvStripe.Stripe',
			'currency' => 'gbp',
			'stripe' => [
				'live' => [
					'secret_key' => 'to-be-provided-by-client',
					'publishable_key' => 'to-be-provided-by-client'
				],
				'dev' => [
					'secret_key' => 'sk_test_5Z0SK51oEvPlaRkh6wKFJ7Gu',
					'publishable_key' => 'pk_test_oTLrM7uYObyZd3BtBIX61mg1'
				],
				'checkout' => [
					'escape' => true, // CakePHP general tag escaping (converts "&" to "&amp; etc")
					'data-image' => null,
					'data-name' => null,
					'data-description' => null,
					'data-locale' => null,
					'data-zip-code' => null, // Boolean; set whether you would like Stripe to validate the billing postal code
					'data-billing-address' => null // Boolean; specify whether you would like to collect billing address
				]
			]
		]
	];

The data in here is used to render a Cake HTML Script tag. You can edit the values in the array to your needs, or even add additional ones as specified at https://stripe.com/docs/checkout#integration-simple-options

The ones added here are just for example purposes; none of the `data-` attributes here are mandatory.

For anything that needs to be set on a per-checkout basis, options can be added/overwritten on your checkout page by adding an Options array along with the element:

	<?= $this->element('EvStripe.stripe_checkout', [
		'options' => [
			'data-foo' => 'bar'
		]
	]) ?>
