<?php if (empty(Configure::read('EvTransactions.stripe.checkout'))): ?>
	<p>Please create the "checkout" array in Config > EvTransactions</p>
	<p>Full details available in the readme</p>
<?php else: ?>
	<?php
		// Merge default tag options with any per-checkout items
		$options = !empty($options) ? array_merge(Configure::read('EvTransactions.stripe.checkout'), $options) : Configure::read('EvTransactions.stripe.checkout');

		// Set class for script tag (Stripe looks for this)
		$options['class'] = 'stripe-button';

		// Set up key
		$options['data-key'] = Configure::read('app.environment') == 'PRODUCTION' ? Configure::read('EvTransactions.stripe.live.publishable_key') : Configure::read('EvTransactions.stripe.dev.publishable_key');
		if (!empty($stripeEmail)) {
			$options['data-email'] = $stripeEmail;
		}
		if (isset($stripeShipping)) {
			$options['data-shipping-address'] = $stripeShipping;
		}
	?>

	<?= $this->Form->create(false, [
		'type' => 'post'
	]); ?>

		<?= $this->Html->script(
			'https://checkout.stripe.com/checkout.js',
			$options
		); ?>

	<?= $this->Form->end(); ?>
<?php endif; ?>
