<?php

/** @var string $stripePublishableKey The live or dev stripe key */
if (!empty($stripePublishableKey) && empty(Configure::read('EvTransactions.stripe.checkout')) && !empty($price)) {
	echo '<p>Please create the "checkout" array in Config > EvTransactions</p><p>Full details available in the readme</p>';
	return;
}

$this->Html->script('https://js.stripe.com/v3/', ['inline' => false]);
$this->Html->scriptBlock('var stripe = Stripe(\'' . $stripePublishableKey . '\');', ['inline' => false]);
$this->Html->script(['EvStripe.serialize_json'], ['inline' => false]);
$this->Html->script(['EvStripe.payment_request'], ['inline' => false]);

$dataTitle = !empty($dataTitle) ? $dataTitle : Configure::read('SiteSetting.general.site_title') . ' Order';

?>

<div id="payment-request-button" data-title="<?=h($dataTitle)?>" data-price="<?=$dataPrice?>" >
	<!-- A Stripe Element will be inserted here. -->
</div>
