<?php
// Example Stripe Form
// ===================
//
// You can either use this form directly using:-
//
//     echo $this->element('EvStripe.payment_form');
//
// Or, use it as a guide to including the relevant form fields. The important thing to note is that
// the input names need excluding so that the card details are not submitted to the server; Stripe
// handles these! Also note that the inputs each have a `data-stripe` attribute that is used by
// Stripe's JavaScript to determine which field is which.

// Elements bound by Stripe JS are included in the payment_elements element (try saying that in a hurry).
?>

<div class="js-stripe-payment-errors"></div>

<div class="form-group required">

	<?php
		echo $this->Form->input('Payment.card_name', [
			'class' => 'form-control required',
			'div' => 'form-group required',
			'name' => false,
			'required' => true,
			'data-stripe' => 'name',
			'label' => 'Name on Card',
		]);

		echo $this->element('EvStripe.payment_elements');

		echo $this->Form->input('PaymentMethodId',[
			'type' => 'hidden',
			'class' => 'form-control',
			'div' => 'form-group',
			'label' => 'PaymentMethodId',
			'name' => 'PaymentMethodId',
			'required' => false,
			'id' => 'PaymentMethodId'
		]);

		echo $this->Form->input('Payment.postcode', [
			'class' => 'form-control',
			'div' => 'form-group',
			'name' => false,
			'data-stripe' => 'address_zip'
		]);

		echo $this->Form->input(
			'PaymentMethodId',
			[
				'type' => 'hidden',
				'class' => 'form-control',
				'div' => 'form-group',
				'label' => 'PaymentMethodId',
				'name' => 'PaymentMethodId',
				'required' => false,
				'id' => 'PaymentMethodId'
			]
		);
	?>

</div>

<?php
	echo $this->Form->button('Submit', [
		'type' => 'submit',
		'class' => 'btn btn-primary right',
		'id' => 'card-button',
		'data-secret' => 'test'
	]);
?>
