<?php

declare(strict_types=1);

namespace Tests\Feature;

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Console\Kernel;
use PHPUnit\Framework\TestCase;
use Tests\TestTwigEnvironmentTrait;

class FiltersTest extends TestCase
{
    use TestTwigEnvironmentTrait;

    /**
     * @dataProvider filtersProvider
     */
    public function testFilters(string $twigTemplate, string $expectedOutput): void
    {
        $twig = $this->getTestTwigEnvironment($twigTemplate);

        // boot laravel as otherwise when "facades" are used they complain about a root not being set
        $app = new Application(__DIR__ . '/../laravel/');
        $app->singleton(Kernel::class);
        $app->get(Kernel::class)->bootstrap();

        $this->assertSame($expectedOutput, $twig->render('test.html.twig'));
    }

    public function filtersProvider(): array
    {
        return [
            'decode' => [ "{{ 'I\'ll &quot;eat&quot; the &lt;b&gt;bacon&lt;/b&gt; now' | decode | raw }}", 'I\'ll "eat" the <b>bacon</b> now' ],
            'dl' => [ "{{ { 'Delicious': [ 'bacon', 'sushi' ], 'Green': [ 'broccoli', 'kale' ] } | dl }}", '<dl><dt>Delicious</dt><dd>bacon</dd><dd>sushi</dd><dt>Green</dt><dd>broccoli</dd><dd>kale</dd></dl>' ],
            'entities' => [ "{{ 'The \'bacon\' is <b>crispy</b>' | entities | raw }}", 'The &#039;bacon&#039; is &lt;b&gt;crispy&lt;/b&gt;' ],
            //'full_urls' => [ "{{ 'I had this totally <a href=\"/dreams/spiders-with-ramen-legs\">crazy dream</a> last night and I know you want to hear all about it!' | full_urls | raw }}", 'I had this totally <a href="https://example.com/dreams/spiders-with-ramen-legs">crazy dream</a> last night and I know you want to hear all about it!' ],
            'gravatar' => [ "{{ 'rswanson@inpra.org' | gravatar }}", 'https://www.gravatar.com/avatar/f4650388367dc01cf2acf16b412b3966' ],
            'gravatar w/params' => [ "{{ 'rswanson@inpra.org' | gravatar(80) }}", 'https://www.gravatar.com/avatar/f4650388367dc01cf2acf16b412b3966?s=80' ],
            'is_json' => [ '{{ \'{"book": "All the places you\\\'ll go"}\' | is_json }}', '1' ],
            'is_json fail' => [ "{{ 'this isn\\'t json' | is_json }}", '' ],
            'link' => [ "{{ 'https://evoluted.net/' | link }}", '<a href="https://evoluted.net/">https://evoluted.net/</a>' ],
        ];
    }
}
