<?php

declare(strict_types=1);

namespace Evoluted\StatamicTwig\Twig;

use Statamic\Fields\Value;
use TwigBridge\Engine\Twig;

class CompilerEngine extends Twig
{
    /**
     * Wrap the get() method to auto-transform any Statamic\Fields\Value objects into their actual values
     *
     * This prevents having to do `{{ my_var.value.what_i_actually_want }}` in Twig
     *
     * @param string $path
     * @param array<mixed> $data
     * @phpcsSuppress SlevomatCodingStandard.TypeHints.ParameterTypeHint.MissingNativeTypeHint
     */
    public function get($path, array $data = []): string
    {
        $data = array_map(function ($item): mixed {
            if (!($item instanceof Value)) {
                return $item;
            }

            return $item->value();
        }, $data);

        return parent::get($path, $data);
    }
}
