<?php

declare(strict_types=1);

namespace Tests;

use Evoluted\StatamicTwig\Twig\StatamicExtension;
use Evoluted\StatamicTwig\Twig\StatamicRuntimeLoader;
use Twig\Environment;
use Twig\Loader\ArrayLoader;

trait TestTwigEnvironmentTrait
{
    private function getTestTwigEnvironment(string $twigTemplate): Environment
    {
        $loader = new ArrayLoader([ 'test.html.twig' => $twigTemplate ]);
        $twig = new Environment($loader, [
            'debug' => false,
            'cache' => false,
            'strict_variables' => true,
            'autoescape' => 'name',
            'optimizations' => 0,
        ]);
        $twig->addExtension(new StatamicExtension());
        $twig->addRuntimeLoader(new StatamicRuntimeLoader());

        return $twig;
    }
}
