<?php

declare(strict_types=1);

namespace Evoluted\StatamicTwig\Twig\TokenParser;

use Evoluted\StatamicTwig\Twig\Node\FormNode;
use Twig\Token;
use Twig\TokenParser\AbstractTokenParser;

/**
 * {% form 'contact' { 'redirect': 'https://google.com' } %}
 *   {% for field in fields %}...{% endfor %}
 * {% endform %}
 */
class FormTokenParser extends AbstractTokenParser
{
    public function parse(Token $token): FormNode
    {
        $stream = $this->parser->getStream();
        $handle = $this->parser->getExpressionParser()->parseStringExpression();
        $params = $this->parser->getExpressionParser()->parseHashExpression();

        $stream->expect(/* Token::BLOCK_END_TYPE */ 3);

        $body = $this->parser->subparse([$this, 'decideBlockEnd'], true);

        $stream->expect(/* Token::BLOCK_END_TYPE */ 3);

        return new FormNode($handle, $params, $body, $token->getLine(), $this->getTag());
    }

    public function decideBlockEnd(Token $token): bool
    {
        return $token->test('endform');
    }

    public function getTag(): string
    {
        return 'form';
    }
}
