<?php

declare(strict_types=1);

namespace Evoluted\StatamicTwig\Twig\TokenParser;

use Evoluted\StatamicTwig\Twig\Node\AssetNode;
use Twig\Token;
use Twig\TokenParser\AbstractTokenParser;

/**
 * {% asset { url: 'https://evoluted.net' } %}
 *      <img src="{{ url }}" alt="{{ alt }}">
 * {% endasset %}
 */
class AssetTokenParser extends AbstractTokenParser
{
    public function parse(Token $token): AssetNode
    {
        $stream = $this->parser->getStream();
        $params = $this->parser->getExpressionParser()->parseHashExpression();

        $stream->expect(/* Token::BLOCK_END_TYPE */ 3);

        $values = $this->parser->subparse([$this, 'decideBlockEnd'], true);

        $stream->expect(/* Token::BLOCK_END_TYPE */ 3);

        return new AssetNode($params, $values, $token->getLine(), $this->getTag());
    }

    public function decideBlockEnd(Token $token): bool
    {
        return $token->test('endasset');
    }

    public function getTag(): string
    {
        return 'asset';
    }
}
