<?php

declare(strict_types=1);

namespace Evoluted\StatamicTwig\Twig\Node;

use Twig\Compiler;
use Twig\Node\Node;
use Twig\Node\NodeCaptureInterface;

class FormNode extends Node implements NodeCaptureInterface
{
    public function __construct(Node $handle, Node $params, Node $body, int $lineno = 0, ?string $tag = null)
    {
        parent::__construct([
            'handle' => $handle,
            'params' => $params,
            'body' => $body,
        ], [], $lineno, $tag);
    }

    public function compile(Compiler $compiler): void
    {
        $compiler->addDebugInfo($this);

        // store the current context for restoration later
        $parentContextName = $compiler->getVarName();
        $compiler->write(sprintf("\$%s = \$context;\n", $parentContextName));

        // get the form handle
        $handleNode = $this->getNode('handle');
        $handleVarName = $compiler->getVarName();
        $compiler->write(sprintf("\$%s = ", $handleVarName))
            ->subcompile($handleNode)
            ->raw(";\n")
        ;

        // parameters
        $paramsNode = $this->getNode('params');
        $paramsVarName = $compiler->getVarName();
        $compiler
            ->write(sprintf('$%s = ', $paramsVarName))
            ->subcompile($paramsNode)
            ->raw(";\n")
            ->write(sprintf("if (!twig_test_iterable(\$%s)) {\n", $paramsVarName))
            ->indent()
            ->write("throw new RuntimeError('Parameters passed to the \"form\" tag must be a hash.', ")
            ->repr($paramsNode->getTemplateLine())
            ->raw(", \$this->getSourceContext());\n")
            ->outdent()
            ->write("}\n")
            ->write(sprintf("\$%s = iterator_to_array(\$%s);\n", $paramsVarName, $paramsVarName))
        ;

        // form parameters
        $formVarName = $compiler->getVarName();
        $compiler
            ->write(sprintf("\$%s = (new \Evoluted\StatamicTwig\Statamic\Forms\Tags())\n", $formVarName))
            ->write("  ->setContext([])\n")
            ->write(sprintf(
                "  ->setParameters(array_merge([ 'form' => \$%s ], \$%s))\n",
                $handleVarName,
                $paramsVarName
            ))
            ->write(";\n")
        ;

        // merge the form parameters into the current context, subcompile the body of the form tag, then restore context
        $compiler
            ->write(sprintf("echo \$%s->getFormOpen();\n", $formVarName))
            ->write(sprintf("echo \$%s->getFormMetaFields();\n", $formVarName))
            ->write(sprintf("\$context = array_merge(\$context, \$%s->getFormParameters());\n", $formVarName))
            ->subcompile($this->getNode('body'))
            ->write(sprintf("echo \$%s->getFormClose();\n", $formVarName))
            ->write(sprintf("\$context = \$%s;\n", $parentContextName))
        ;
    }
}
