<?php

declare(strict_types=1);

namespace Evoluted\StatamicTwig\Twig\Node;

use Twig\Compiler;
use Twig\Node\Node;
use Twig\Node\NodeCaptureInterface;

class AssetNode extends Node implements NodeCaptureInterface
{
    public function __construct(Node $params, Node $body, int $lineno = 0, ?string $tag = null)
    {
        parent::__construct([ 'params' => $params, 'body' => $body ], [], $lineno, $tag);
    }

    public function compile(Compiler $compiler): void
    {
        $compiler->addDebugInfo($this);

        // most of this is cribbed from Twig\Node\WithNode
        $parentContextName = $compiler->getVarName();
        $compiler->write(sprintf("\$%s = \$context;\n", $parentContextName));


        // ensure that we have parameters
        $paramsNode = $this->getNode('params');
        $paramsVarName = $compiler->getVarName();
        $compiler
            ->write(sprintf('$%s = ', $paramsVarName))
            ->subcompile($paramsNode)
            ->raw(";\n")
            ->write(sprintf("if (!twig_test_iterable(\$%s)) {\n", $paramsVarName))
            ->indent()
            ->write("throw new RuntimeError('Parameters passed to the \"asset\" tag must be a hash.', ")
            ->repr($paramsNode->getTemplateLine())
            ->raw(", \$this->getSourceContext());\n")
            ->outdent()
            ->write("}\n")
            ->write(sprintf("\$%s = iterator_to_array(\$%s);\n", $paramsVarName, $paramsVarName))
        ;

        // fetch the asset
        $assetVarName = $compiler->getVarName();
        $compiler
            ->write(sprintf("\$%s = (new \Statamic\Tags\Asset())\n", $assetVarName))
            ->write("  ->setContext([])\n")
            ->write(sprintf("  ->setParameters(\$%s)\n", $paramsVarName))
            ->write("  ->index()\n")
            ->write(";\n")
        ;

        // devtodo check if the asset actually returned?

        // 1. fresh context with whatever Statamic\Assets\Asset (or Statamic\Assets\AugmentedAsset) -> toArray chucks up
        // 2. write the body
        // 3. reset the context
        $compiler
            ->write(sprintf("\$context = \$%s->toArray();\n", $assetVarName))
            ->subcompile($this->getNode('body'))
            ->write(sprintf("\$context = \$%s;\n", $parentContextName))
        ;
    }
}
