<?php

declare(strict_types=1);

namespace Tests\Feature;

use Illuminate\Foundation\Application;
use PHPUnit\Framework\TestCase;
use Tests\TestTwigEnvironmentTrait;

class FunctionTest extends TestCase
{
    use TestTwigEnvironmentTrait;

    /**
     * @group BootsLaravel
     */
    public function testSvg(): void
    {
        $twig = $this->getTestTwigEnvironment("{{ svg('test.svg', { 'class': 'testclass', 'test': 'tset' }) }}");

        // boot laravel as SVG tag uses resource_path(), public_path() global methods, as well as File and URL "facades"
        $app = new Application(__DIR__ . '/../laravel/');
        $app->bind(\Illuminate\Contracts\Console\Kernel::class, \Illuminate\Foundation\Console\Kernel::class);
        $app->get(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

        $expectedSvg = '<svg class="testclass" test="tset" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"> <path d="M50,30c9-22 42-24 48,0c5,40-40,40-48,65c-8-25-54-25-48-65c 6-24 39-22 48,0 z" fill="#F00" stroke="#000"/> </svg>';

        $this->assertSame($expectedSvg, $twig->render('test.html.twig'));
    }
}
