<?php

declare(strict_types=1);

namespace Evoluted\StatamicTwig\Twig;

use Evoluted\StatamicTwig\Twig\TokenParser\AssetTokenParser;
use Evoluted\StatamicTwig\Twig\TokenParser\FormTokenParser;
use Statamic\Modifiers\CoreModifiers;
use Statamic\Tags\Collection\Collection;
use Statamic\Tags\GetContent;
use Statamic\Tags\Nav;
use Statamic\Tags\Svg;
use Statamic\Tags\Taxonomy\Taxonomy;
use Statamic\Tags\Users;
use Twig\Extension\AbstractExtension;
use Twig\TokenParser\TokenParserInterface;
use Twig\TwigFilter;
use Twig\TwigFunction;

class StatamicExtension extends AbstractExtension
{
    /**
     * @return array<TwigFilter>
     */
    public function getFilters(): array
    {
        return [
            new TwigFilter('add_slashes', [ CoreModifiers::class, 'addSlashes' ], [ 'is_safe' => [ 'html' ]]),
            $this->variadicProxy('ampersand_list', 'ampersandList', [ 'is_safe' => [ 'html' ]]),
            new TwigFilter('ascii', [ CoreModifiers::class, 'ascii' ]),
            $this->variadicProxy('at'),
            new TwigFilter('background_position', [ CoreModifiers::class, 'backgroundPosition' ]),
            $this->variadicProxy('backspace'),
            new TwigFilter('camelize', [ CoreModifiers::class, 'camelize' ]),
            new TwigFilter('cdata', [ CoreModifiers::class, 'cdata' ], [ 'is_safe' => [ 'html' ]]),
            new TwigFilter('collapse', [ CoreModifiers::class, 'collapse' ]),
            new TwigFilter('collapse_whitespace', [ CoreModifiers::class, 'collapseWhitespace' ]),
            new TwigFilter('compact', [ CoreModifiers::class, 'compact' ]),
            new TwigFilter('console_log', [ CoreModifiers::class, 'consoleLog' ], [ 'is_safe' => [ 'html' ]]),
            $this->variadicProxyWithContext('contains_all', 'containsAll'),
            $this->variadicProxy('contains_any', 'containsAny'),
            $this->variadicProxy('count_substring', 'countSubstring'),
            new TwigFilter('dashify', [ CoreModifiers::class, 'dashify' ]),
            $this->variadicProxy('days_ago', 'daysAgo'),
            new TwigFilter('decode', [ CoreModifiers::class, 'decode' ]),
            new TwigFilter('deslugify', [ CoreModifiers::class, 'deslugify' ]),
            $this->variadicProxy('dl', 'dl', [ 'is_safe' => [ 'html' ]]),
            new TwigFilter('dump', [ CoreModifiers::class, 'dump' ]),
            new TwigFilter('embed_url', [ CoreModifiers::class, 'embedUrl' ]),
            $this->variadicProxy('ends_with', 'endsWith'),
            $this->variadicProxy('ensure_left', 'ensureLeft'),
            $this->variadicProxy('ensure_right', 'ensureRight'),
            new TwigFilter('entities', [ CoreModifiers::class, 'entities' ]),
            $this->variadicProxy('excerpt'),
            $this->variadicProxy('explode', 'explode', [ 'is_safe' => [ 'html' ]]),
            $this->variadicProxy('favicon', 'favicon', [ 'is_safe' => [ 'html' ]]),
            new TwigFilter('flatten', [ CoreModifiers::class, 'flatten' ]),
            new TwigFilter('flip', [ CoreModifiers::class, 'flip' ]),
            $this->variadicProxy('format'),
            $this->variadicProxy('format_number', 'formatNumber'),
            // requires a statamic site is set up to get the active domain
            //new TwigFilter('full_urls', [ CoreModifiers::class, 'fullUrls' ]),
            $this->variadicProxy('gravatar'),
            new TwigFilter('has_lower_case', [ CoreModifiers::class, 'hasLowerCase' ]),
            new TwigFilter('has_upper_case', [ CoreModifiers::class, 'hasUpperCase' ]),
            $this->variadicProxy('hours_ago', 'hoursAgo'),
            $this->variadicProxy('image', 'image', [ 'is_safe' => [ 'html' ]]),
            $this->variadicProxy('insert'),
            $this->variadicProxyWithContext('is_after', 'isAfter'),
            new TwigFilter('is_alpha', [ CoreModifiers::class, 'isAlpha' ]),
            new TwigFilter('is_alphanumeric', [ CoreModifiers::class, 'isAlphanumeric' ]),
            new TwigFilter('is_array', [ CoreModifiers::class, 'isArray' ]),
            $this->variadicProxyWithContext('is_before', 'isBefore'),
            $this->variadicProxyWithContext('is_between', 'isBetween'),
            new TwigFilter('is_blank', [ CoreModifiers::class, 'isBlank' ]),
            new TwigFilter('is_email', [ CoreModifiers::class, 'isEmail' ]),
            new TwigFilter('is_embeddable', [ CoreModifiers::class, 'isEmbeddable' ]),
            new TwigFilter('is_empty', [ CoreModifiers::class, 'isEmpty' ]),
            new TwigFilter('is_future', [ CoreModifiers::class, 'isFuture' ]),
            new TwigFilter('is_json', [ CoreModifiers::class, 'isJson' ]),
            new TwigFilter('is_leap_year', [ CoreModifiers::class, 'isLeapYear' ]),
            new TwigFilter('is_lowercase', [ CoreModifiers::class, 'isLowercase' ]),
            new TwigFilter('is_numberwang', [ CoreModifiers::class, 'isNumberwang' ]),
            new TwigFilter('is_numeric', [ CoreModifiers::class, 'isNumeric' ]),
            new TwigFilter('is_past', [ CoreModifiers::class, 'isPast' ]),
            new TwigFilter('is_today', [ CoreModifiers::class, 'isToday' ]),
            new TwigFilter('is_tomorrow', [ CoreModifiers::class, 'isTomorrow' ]),
            new TwigFilter('is_uppercase', [ CoreModifiers::class, 'isUppercase' ]),
            new TwigFilter('is_url', [ CoreModifiers::class, 'isUrl' ]),
            new TwigFilter('is_weekday', [ CoreModifiers::class, 'isWeekday' ]),
            new TwigFilter('is_weekend', [ CoreModifiers::class, 'isWeekend' ]),
            new TwigFilter('is_yesterday', [ CoreModifiers::class, 'isYesterday' ]),
            $this->variadicProxy('iso_format', 'isoFormat'),
            new TwigFilter('lcfirst', [ CoreModifiers::class, 'lcfirst' ]),
            $this->variadicProxy('link', 'link', [ 'is_safe' => [ 'html' ]]),
            new TwigFilter('md5', [ CoreModifiers::class, 'md5' ]),
            $this->variadicProxy('minutes_ago', 'minutesAgo'),
            $this->variadicProxy('modify_date', 'modifyDate'),
            $this->variadicProxy('months_ago', 'monthsAgo'),
            new TwigFilter('obfuscate', [ CoreModifiers::class, 'obfuscate' ], [ 'is_safe' => [ 'html' ]]),
            $this->variadicProxy('obfuscate_email', 'obfuscateEmail', [ 'is_safe' => [ 'html' ]]),
            $this->variadicProxy('option_list', 'optionList'),
            $this->variadicProxy('pathinfo'),
            $this->variadicProxy('piped', 'optionList'),
            new TwigFilter('rawurlencode', [ CoreModifiers::class, 'rawurlencode' ]),
            $this->variadicProxy('read_time', 'readTime'),
            $this->variadicProxy('regex_replace', 'regexReplace'),
            $this->variadicProxy('relative'),
            $this->variadicProxy('remove_left', 'removeLeft'),
            $this->variadicProxy('remove_right', 'removeRight'),
            new TwigFilter('reverse', [ CoreModifiers::class, 'reverse' ]),
            $this->variadicProxy('safe_truncate', 'safeTruncate'),
            $this->variadicProxy('seconds_ago', 'secondsAgo'),
            new TwigFilter('singular', [ CoreModifiers::class, 'singular' ]),
            $this->variadicProxy('smartypants'),
            $this->variadicProxy('sort', 'sort', [ 'is_safe' => [ 'html' ]]),
            $this->variadicProxy('spaceless'),
            $this->variadicProxy('starts_with', 'startsWith'),
            $this->variadicProxy('sum'),
            $this->variadicProxy('surround'),
            new TwigFilter('swap_case', [ CoreModifiers::class, 'swapCase' ]),
            $this->variadicProxy('table', 'table', [ 'is_safe' => [ 'html' ]]),
            new TwigFilter('tidy', [ CoreModifiers::class, 'tidy' ]),
            new TwigFilter('title', [ CoreModifiers::class, 'title' ]),
            new TwigFilter('trim', [ CoreModifiers::class, 'trim' ]),
            $this->variadicProxy('truncate'),
            new TwigFilter('ucfirst', [ CoreModifiers::class, 'ucfirst' ]),
            $this->variadicProxy('ul', 'ul', [ 'is_safe' => [ 'html' ] ]),
            new TwigFilter('underscored', [ CoreModifiers::class, 'underscored' ], [ 'is_safe' => [ 'html' ]]),
            $this->variadicProxy('unique'),
            new TwigFilter('upper', [ CoreModifiers::class, 'upper' ]),
            new TwigFilter('urldecode', [ CoreModifiers::class, 'urldecode' ], [ 'is_safe' => [ 'html' ]]),
            new TwigFilter('urlencode', [ CoreModifiers::class, 'urlencode' ], [ 'is_safe' => [ 'html' ]]),
            $this->variadicProxy('weeks_ago', 'weeksAgo'),
            $this->variadicProxy('widont'),
            new TwigFilter('word_count', [ CoreModifiers::class, 'wordCount' ]),
            $this->variadicProxy('wrap'),
            $this->variadicProxy('years_ago', 'yearsAgo'),
        ];
    }

    /**
     * @return array<TwigFunction>
     */
    public function getFunctions(): array
    {
        return [
            new TwigFunction('collection', function (string $from, array $attributes = []) {
                return (new Collection())
                    ->setContext([])
                    ->setParameters(array_merge([ 'from' => $from ], $attributes))
                    ->index()
                ;
            }),
            new TwigFunction('get_content', function (string $from, array $attributes = []) {
                return (new GetContent())
                    ->setContext([])
                    ->setParameters(array_merge([ 'from' => $from ], $attributes))
                    ->index()
                    ;
            }),
            new TwigFunction('nav', function (array $params = []) {
                return (new Nav())->setContext([])->setParameters($params)->index();
            }),
            new TwigFunction('svg', [ $this, 'svg' ], [ 'is_safe' => [ 'html' ] ]),
            new TwigFunction('users', function (array $params = []) {
                return (new Users())->setContext([])->setParameters($params)->index();
            }),
            new TwigFunction('entries', function ($entries) {
                return $entries->get();
            }),
            new TwigFunction('taxonomy', function (string $from, array $attributes = []) {
                return (new Taxonomy())
                    ->setContext([])
                    ->setParameters(array_merge([ 'from' => $from ], $attributes))
                    ->index()
                ;
            }),
        ];
    }

    /**
     * @return array<TokenParserInterface>
     */
    public function getTokenParsers(): array
    {
        return [
            new AssetTokenParser(),
            new FormTokenParser(),
        ];
    }

    /**
     * @param array<string,string> $attributes
     */
    public function svg(string $src, array $attributes = []): string
    {
        $svg = new Svg();
        $svg->setContext([])
            ->setParameters(array_merge([ 'src' => $src ], $attributes))
        ;

        return $svg->index();
    }

    /**
     * For variadic filters Twig requires the array parameter to have a default blank array which CoreModifiers doesn't
     * provide, so even though they're mostly suitable as-is, Twig won't use them without us proxying them
     *
     * @param array<string,mixed> $options
     */
    private function variadicProxy(string $filterName, ?string $methodName = null, array $options = []): TwigFilter
    {
        $methodName ??= $filterName;

        return new TwigFilter(
            $filterName,
            fn(mixed $v, array $p = []): mixed => (new CoreModifiers())->{$methodName}($v, $p),
            array_merge([ 'is_variadic' => true ], $options)
        );
    }

    /**
     * @param array<string,mixed> $options
     */
    private function variadicProxyWithContext(
        string $filterName,
        ?string $methodName = null,
        array $options = []
    ): TwigFilter {
        $methodName ??= $filterName;

        return new TwigFilter(
            $filterName,
            fn(mixed $c, mixed $v, array $p = []): mixed => (new CoreModifiers())->{$methodName}($v, $p, $c),
            array_merge([ 'is_variadic' => true, 'needs_context' => true ], $options)
        );
    }
}
