<?php

declare(strict_types=1);

namespace Evoluted\StatamicTwig\Statamic\Forms;

use Statamic\Forms\Tags as BaseTags;

class Tags extends BaseTags
{
    /**
     * @return array<string,mixed>
     */
    public function getFormParameters(): array
    {
        $form = $this->form();
        $data = $this->getFormSession($this->sessionHandle());

        /** @phpstan-ignore-next-line getFields treats JSDriver as a boolean */
        $fields = $this->getFields($this->sessionHandle(), false);
        // allow fields to be accessible by their handle
        $keys = array_map(fn(array $v): string => $v['handle'], $fields);
        $data['fields'] = array_combine($keys, $fields);

        $data['honeypot'] = $form->honeypot();

        return $data;
    }

    public function getFormMetaFields(): string
    {
        $params = [];
        $redirect = $this->getRedirectUrl();
        $errorRedirect = $this->getErrorRedirectUrl();

        if ($redirect) {
            $params['redirect'] = $this->parseRedirect($redirect);
        }

        if ($errorRedirect) {
            $params['error_redirect'] = $this->parseRedirect($errorRedirect);
        }

        return $this->formMetaFields($params);
    }

    public function getFormOpen(): string
    {
        $form = $this->form();

        $knownParams = array_merge(static::HANDLE_PARAM, [
            'redirect', 'error_redirect', 'allow_request_redirect', 'csrf', 'files', 'js',
        ]);

        $action = $this->params->get('action', $form->actionUrl());
        $method = $this->params->get('method', 'POST');

        return $this->formOpen($action, $method, $knownParams);
    }

    public function getFormClose(): string
    {
        return $this->formClose();
    }
}
