<?php

declare(strict_types=1);

namespace Evoluted\StatamicTwig;

use Evoluted\StatamicTwig\Twig\CompilerEngine;
use Evoluted\StatamicTwig\Twig\StatamicExtension;
use Evoluted\StatamicTwig\Twig\StatamicRuntimeLoader;
use Illuminate\Support\Facades\Config;
use Statamic\Providers\AddonServiceProvider;
use Twig\Environment;
use TwigBridge\Engine\Compiler;
use TwigBridge\Twig\Loader;

class ServiceProvider extends AddonServiceProvider
{
    public function register(): void
    {
        // use our overridden engine instead of TwigBridge's
        $this->app->bind('twig.engine', function () {
            /** @var Compiler $compiler */
            $compiler = $this->app->make('twig.compiler');
            /** @var Loader $loader */
            $loader = $this->app->make('twig.loader.viewfinder');
            /** @var Config $config */
            $config = $this->app->make('config');
            /** @var array<mixed> $globals */
            $globals = $config->get('twigbridge.twig.globals', []);

            return new CompilerEngine($compiler, $loader, $globals);
        });
    }

    public function bootAddon(): void
    {
        /** @var Environment $twig */
        $twig = $this->app->get(Environment::class);
        $twig->addExtension(new StatamicExtension());
        $twig->addRuntimeLoader(new StatamicRuntimeLoader());
    }
}
