# Statamic Twig

Addon to enable the [Twig](https://twig.symfony.com/) templating engine for [Statamic CMS](https://statamic.com/).

## Installation

Use the normal [Statamic method for addon installation](https://statamic.dev/addons#installing-addons):

```shell
composer require evoluted/statamic-twig
```

## Compatibility

The Statamic Twig addon is compatible with:

1. Statamic CMS 3.3
2. Twig 3.4
3. PHP 8.1

## Features

This addon attempts to provide as seamless as transition from Antlers as possible. Where there is built in Antlers functionality that already has a Twig equivalent, the Twig functionality has been used.

### Modifiers

[Statamic modifiers](https://statamic.dev/reference/modifiers) are almost identical to [Twig's filters](https://twig.symfony.com/doc/3.x/templates.html#filters). Converting from Antlers modifier syntax to Twig should be straightforward

```antlers
{{ books | add:magazines }}
```

would become:

```twig
{{ books | add(magazines) }}
```

| Modifier            | Available | Twig native | Notes                                                                                                     |
|---------------------|-----------|-------------|-----------------------------------------------------------------------------------------------------------|
| add                 | ✗         | ✓           | Use built in [math operators](https://twig.symfony.com/doc/3.x/templates.html#math)                       |
| add_slashes         | ✓         | ✗           |                                                                                                           |
| ampersand_list      | ✓         | ✗           |                                                                                                           |
| as                  | ✗         | ✓           | Use [`{% set %}`](https://twig.symfony.com/doc/3.x/tags/set.html)                                         |
| ascii               | ✓         | ✗           |                                                                                                           |
| at                  | ✓         | ✗           |                                                                                                           |
| background_position | ✓         | ✗           |                                                                                                           |
| backspace           | ✓         | ✗           |                                                                                                           |
| camelize            | ✓         | ✗           |                                                                                                           |
| cdata               | ✓         | ✗           |                                                                                                           |
| ceil                | ✗         | ✓           | Use the ["round" filter](https://twig.symfony.com/doc/3.x/filters/round.html)                             |
| chunk               | ✗         | ✓           | Use [loop variables](https://twig.symfony.com/doc/3.x/tags/for.html#the-loop-variable)                    |
| collapse            | ✓         | ✗           |                                                                                                           |
| collapse_whitespace | ✓         | ✗           |                                                                                                           |
| compact             | ✗         | ✗           | Use the ["split" filter](https://twig.symfony.com/doc/3.x/filters/split.html)                             |
| console_log         | ✗         | ✗           |                                                                                                           |
| contains            | ✗         | ✗           | Use the ["in" containment operator](https://twig.symfony.com/doc/3.x/templates.html#containment-operator) |
| contains_all        | ✓         | ✗           |                                                                                                           |
| contains_any        | ✓         | ✗           |                                                                                                           |
| count               | ✗         | ✓           | Use the ["length" filter](https://twig.symfony.com/doc/3.x/filters/length.html)                           |
| count_substring     | ✓         | ✗           |                                                                                                           |
| dashify             | ✓         | ✗           |                                                                                                           |
| days_ago            | ✓         | ✗           |                                                                                                           |
| decode              | ✓         | ✗           |                                                                                                           |
| deslugify           | ✓         | ✗           |                                                                                                           |
| divide              | ✗         | ✓           | Use built in [math operators](https://twig.symfony.com/doc/3.x/templates.html#math)                       |
| dl                  | ✓         | ✗           |                                                                                                           |
| dump                | ✗         | ✓           |                                                                                                           |
| embed_url           | ✓         | ✗           |                                                                                                           |
| ends_with           | ✓         | ✗           |                                                                                                           |
| ensure_left         | ✓         | ✗           |                                                                                                           |
| ensure_right        | ✓         | ✗           |                                                                                                           |
| entities            | ✓         | ✗           |                                                                                                           |
| excerpt             | ✓         | ✗           |                                                                                                           |
| explode             | ✓         | ✗           |                                                                                                           |
| favicon             | ✓         | ✗           |                                                                                                           |
| first               | ✗         | ✓           |                                                                                                           |
| flatten             | ✓         | ✗           |                                                                                                           |
| flip                | ✓         | ✗           |                                                                                                           |
| floor               | ✗         | ✓           | Use the ["round" filter](https://twig.symfony.com/doc/3.x/filters/round.html)                             |
| format              | ✓         | ✗           |                                                                                                           |
| format_localized    | ✗         | ✗           |                                                                                                           |
| format_number       | ✓         | ✗           |                                                                                                           |
| full_urls           | ✗         | ✗           |                                                                                                           |
| get                 | ✗         | ✗           |                                                                                                           |
| gravatar            | ✓         | ✗           |                                                                                                           |
| group_by            | ✗         | ✗           |                                                                                                           |
| has_lower_case      | ✓         | ✗           |                                                                                                           |
| has_upper_case      | ✓         | ✗           |                                                                                                           |
| hours_ago           | ✓         | ✗           |                                                                                                           |
| image               | ✓         | ✗           |                                                                                                           |
| in_array            | ✗         | ✓           | Use the ["in" containment operator](https://twig.symfony.com/doc/3.x/templates.html#containment-operator) |
| insert              | ✓         | ✗           |                                                                                                           |
| is_after            | ✓         | ✗           |                                                                                                           |
| is_alpha            | ✓         | ✗           |                                                                                                           |
| is_alphanumeric     | ✓         | ✗           |                                                                                                           |
| is_array            | ✓         | ✗           |                                                                                                           |
| is_before           | ✓         | ✗           |                                                                                                           |
| is_between          | ✓         | ✗           |                                                                                                           |
| is_blank            | ✓         | ✗           |                                                                                                           |
| is_email            | ✓         | ✗           |                                                                                                           |
| is_embeddable       | ✓         | ✗           |                                                                                                           |
| is_empty            | ✓         | ✗           |                                                                                                           |
| is_future           | ✓         | ✗           |                                                                                                           |
| is_json             | ✓         | ✗           |                                                                                                           |
| is_leap_year        | ✓         | ✗           |                                                                                                           |
| is_lowercase        | ✓         | ✗           |                                                                                                           |
| is_numberwang       | ✓         | ✗           |                                                                                                           |
| is_numeric          | ✓         | ✗           |                                                                                                           |
| is_past             | ✓         | ✗           |                                                                                                           |
| is_today            | ✓         | ✗           |                                                                                                           |
| is_tomorrow         | ✓         | ✗           |                                                                                                           |
| is_uppercase        | ✓         | ✗           |                                                                                                           |
| is_url              | ✓         | ✗           |                                                                                                           |
| is_weekday          | ✓         | ✗           |                                                                                                           |
| is_weekend          | ✓         | ✗           |                                                                                                           |
| is_yesterday        | ✓         | ✗           |                                                                                                           |
| iso_format          | ✓         | ✗           |                                                                                                           |
| join                | ✗         | ✓           |                                                                                                           |
| last                | ✗         | ✓           |                                                                                                           |
| lcfirst             | ✓         | ✗           |                                                                                                           |
| length              | ✗         | ✓           |                                                                                                           |
| limit               | ✗         | ✓           | Use the ["slice" filter](https://twig.symfony.com/doc/3.x/filters/slice.html)                             |
| link                | ✓         | ✗           |                                                                                                           |
| list                | ✗         | ✓           | Use the ["join" filter](https://twig.symfony.com/doc/3.x/filters/join.html)                               |
| lower               | ✗         | ✓           |                                                                                                           |
| macro               | ✗         | ✗           |                                                                                                           |
| mailto              | ✗         | ✗           |                                                                                                           |
| markdown            | ✗         | ✗           |                                                                                                           |
| md5                 | ✓         | ✗           |                                                                                                           |
| minutes_ago         | ✓         | ✗           |                                                                                                           |
| mod                 | ✗         | ✓           | Use built in [math operators](https://twig.symfony.com/doc/3.x/templates.html#math)                       |
| modify_date         | ✓         | ✗           |                                                                                                           |
| months_ago          | ✓         | ✗           |                                                                                                           |
| multiply            | ✗         | ✓           | Use built in [math operators](https://twig.symfony.com/doc/3.x/templates.html#math)                       |
| nl2br               | ✗         | ✓           |                                                                                                           |
| obfuscate           | ✓         | ✗           |                                                                                                           |
| obfuscate_email     | ✓         | ✗           |                                                                                                           |
| offset              | ✗         | ✗           |                                                                                                           |
| ol                  | ✗         | ✗           |                                                                                                           |
| option_list         | ✓         | ✗           |                                                                                                           |
| output              | ✗         | ✗           |                                                                                                           |
| pad                 | ✗         | ✗           |                                                                                                           |
| parse_url           | ✗         | ✗           |                                                                                                           |
| partial             | ✗         | ✗           |                                                                                                           |
| pathinfo            | ✓         | ✗           |                                                                                                           |
| piped               | ✓         | ✗           |                                                                                                           |
| plural              | ✗         | ✗           |                                                                                                           |
| raw                 | ✗         | ✓           |                                                                                                           |
| rawurlencode        | ✓         | ✗           |                                                                                                           |
| ray                 | ✗         | ✗           |                                                                                                           |
| read_time           | ✓         | ✗           |                                                                                                           |
| regex_replace       | ✓         | ✗           |                                                                                                           |
| relative            | ✓         | ✗           |                                                                                                           |
| remove_left         | ✓         | ✗           |                                                                                                           |
| remove_right        | ✓         | ✗           |                                                                                                           |
| repeat              | ✗         | ✗           |                                                                                                           |
| replace             | ✗         | ✓           |                                                                                                           |
| reverse             | ✗         | ✓           |                                                                                                           |
| round               | ✗         | ✓           |                                                                                                           |
| safe_truncate       | ✓         | ✗           |                                                                                                           |
| sanitize            | ✗         | ✗           |                                                                                                           |
| seconds_ago         | ✓         | ✗           |                                                                                                           |
| segment             | ✗         | ✗           |                                                                                                           |
| sentence_list       | ✗         | ✗           |                                                                                                           |
| shuffle             | ✗         | ✗           |                                                                                                           |
| singular            | ✓         | ✗           |                                                                                                           |
| slugify             | ✗         | ✗           |                                                                                                           |
| smartypants         | ✓         | ✗           |                                                                                                           |
| sort                | ✓         | ✗           |                                                                                                           |
| spaceless           | ✓         | ✗           |                                                                                                           |
| starts_with         | ✓         | ✗           |                                                                                                           |
| strip_tags          | ✗         | ✓           |                                                                                                           |
| substr              | ✗         | ✓           | Use the ["slice" filter](https://twig.symfony.com/doc/3.x/filters/slice.html)                             |
| subtract            | ✗         | ✗           | Use built in [math operators](https://twig.symfony.com/doc/3.x/templates.html#math)                       |
| sum                 | ✓         | ✗           |                                                                                                           |
| surround            | ✓         | ✗           |                                                                                                           |
| swap_case           | ✓         | ✗           |                                                                                                           |
| table               | ✓         | ✗           |                                                                                                           |
| tidy                | ✓         | ✗           |                                                                                                           |
| timezone            | ✗         | ✗           |                                                                                                           |
| title               | ✓         | ✗           |                                                                                                           |
| to_json             | ✗         | ✓           | Use the ["json_encode" filter](https://twig.symfony.com/doc/3.x/filters/json_encode.html)                 |
| to_spaces           | ✗         | ✗           |                                                                                                           |
| to_tabs             | ✗         | ✗           |                                                                                                           |
| trim                | ✓         | ✗           |                                                                                                           |
| truncate            | ✓         | ✗           |                                                                                                           |
| ucfirst             | ✓         | ✗           |                                                                                                           |
| ul                  | ✓         | ✗           |                                                                                                           |
| underscored         | ✓         | ✗           |                                                                                                           |
| unique              | ✓         | ✗           |                                                                                                           |
| upper               | ✓         | ✗           |                                                                                                           |
| url                 | ✗         | ✗           |                                                                                                           |
| urldecode           | ✓         | ✗           |                                                                                                           |
| urlencode           | ✓         | ✗           |                                                                                                           |
| weeks_ago           | ✓         | ✗           |                                                                                                           |
| where               | ✗         | ✓           | Use the ["filter" filter](https://twig.symfony.com/doc/3.x/filters/filter.html)                           |
| widont              | ✓         | ✗           |                                                                                                           |
| word_count          | ✓         | ✗           |                                                                                                           |
| wrap                | ✓         | ✗           |                                                                                                           |
| years_ago           | ✓         | ✗           |                                                                                                           |

### Tags

Most [Statamic tags](https://statamic.dev/reference/tags) could easily be [Twig functions](https://twig.symfony.com/doc/3.x/templates.html#functions) as much as [Twig tags](https://twig.symfony.com/doc/3.x/tags/index.html). Twig functions have been used if that would be more idiomatic Twig (i.e. `{{ }}` outputs, whereas `{% %}` does something).

| Tag                                                           | Available | Usage                                       | Notes                                                                                                       |
|---------------------------------------------------------------|-----------|---------------------------------------------|-------------------------------------------------------------------------------------------------------------|
| [Asset](https://statamic.dev/tags/asset)                      | ✓         | `{% asset { 'url': '...' } %}`              |                                                                                                             |
| [Cache](https://statamic.dev/tags/cache)                      | ✗         |                                             | Use the ["cache" tag](https://twig.symfony.com/doc/3.x/tags/cache.html) extra                               |
| [Collection](https://statamic.dev/tags/collection)            | ✓         | `{% for entry in collection({ ... }) %}`    |                                                                                                             |
| [Dump](https://statamic.dev/tags/dump)                        | ✗         |                                             | Use the ["dump" function](https://twig.symfony.com/doc/3.x/functions/dump.html)                             |
| [Foreach](https://statamic.dev/tags/foreach)                  | ✗         |                                             | Use the ["for" tag](https://twig.symfony.com/doc/3.x/tags/for.html)                                         |
 | [Form:create](https://statamic.dev/tags/form-create)          | ✓         | `{% form 'handle' { 'redirect': '...' } %}` |                                                                                                             |
| [Nav](https://statamic.dev/tags/nav)                          | ✓         | `{% for entry in nav(...) %}`               |                                                                                                             |
| [Route](https://statamic.dev/tags/route)                      | ✗         |                                             | Use the [TwigBridge "route" function](https://github.com/rcrowe/TwigBridge#functionsfiltersvariables)       |
| [SVG](https://statamic.dev/tags/svg)                          | ✓         | `{{ svg('test.svg', { 'class': '...' }) }}` | Uses output syntax `{{ }}` rather than tag syntax                                                           |
| [Partial](https://statamic.dev/tags/partial)                  | ✗         |                                             | Use the ["include" tag](https://twig.symfony.com/doc/3.x/tags/include.html)                                 |
| [Partial:exists](https://statamic.dev/tags/partial-exists)    | ✗         |                                             | No equivalent                                                                                               |
| [Partial:if_exists](https://statamic.dev/tags/partial-exists) | ✗         |                                             | Use the ["ignore missing" parameter of the include tag](https://twig.symfony.com/doc/3.x/tags/include.html) |
| [Users](https://statamic.dev/tags/users)                      | ✓         | `{% for user in users({ ... }) %}`          |                                                                                                             |

## Tests

There is a test suite to try and ensure that Antlers / Statamic functionality is maintained as much as possible.

Some functionality relies on Laravel facades, often meaning that a synthetic Laravel install is needed to test, these are in the `tests/Feature` folder.

Other functionality relies on Statamic (assets, forms etc.) and isn't currently tested.
