<?php

declare(strict_types=1);

namespace Tests\Unit;

use PHPUnit\Framework\TestCase;
use Statamic\Facades\Asset;
use Statamic\Assets\Asset as AssetModel;
use Tests\TestTwigEnvironmentTrait;

class TagTest extends TestCase
{
    use TestTwigEnvironmentTrait;

    public function testAsset(): void
    {
        $twig = $this->getTestTwigEnvironment("{% asset { 'url': 'https://www.evoluted.net' } %}{{ url }} \"{{ alt }}\"{% endasset %}");

        $asset = $this->createMock(AssetModel::class);
        $asset->method('toArray')
            ->willReturn([
                'url' => 'https://test.test',
                'alt' => 'This is an alt tag',
            ])
        ;

        Asset::shouldReceive('find')
            ->with('https://www.evoluted.net')
            ->andReturn($asset)
        ;

        $this->assertSame('https://test.test "This is an alt tag"', $twig->render('test.html.twig', []));
    }
}
