<?php

declare(strict_types=1);

namespace Tests\Unit;

use Evoluted\StatamicTwig\Twig\StatamicExtension;
use Evoluted\StatamicTwig\Twig\StatamicRuntimeLoader;
use PHPUnit\Framework\TestCase;
use Twig\Environment;
use Twig\Loader\ArrayLoader;

class FiltersTest extends TestCase
{
    /**
     * @dataProvider filtersProvider
     */
    public function testFilters(string $twigTemplate, string $expectedOutput): void
    {
        $loader = new ArrayLoader([ 'test.html.twig' => $twigTemplate ]);
        $twig = new Environment($loader, [
            'debug' => false,
            'cache' => false,
            'strict_variables' => true,
            'autoescape' => 'name',
            'optimizations' => 0,
        ]);
        $twig->addExtension(new StatamicExtension());
        $twig->addRuntimeLoader(new StatamicRuntimeLoader());

        // some filters (e.g. obfuscate_email) use rand() so make it deterministic
        srand(1234567890);

        $this->assertSame($expectedOutput, $twig->render('test.html.twig'));
    }

    public function filtersProvider(): array
    {
        return [
            'add_slashes' => [ "{{ '\"I\\'m not listening!\" said the small, strange creature.'|add_slashes }}", '\\"I\\\'m not listening!\\" said the small, strange creature.' ],
            'ampersand_list' => [ "{{ [ 'apples', 'bananas', 'jerky' ]|ampersand_list }}", 'apples, bananas &amp; jerky' ],
            'ampersand_list w/params' => [ "{{ [ 'apples', 'bananas', 'jerky' ]|ampersand_list('and') }}", 'apples, bananas and jerky' ],
            'ascii' => [ "{{ 'lemoñade'|ascii }}", 'lemonade' ],
            'background_position' => [ "{{ '50-30'|background_position }}", '50% 30%' ],
            'backspace' => [ "{{ 'supercalifragilisticexpialidocious'|backspace(29) }}", 'super' ],
            'obfuscate_email' => [ "{{ 'test@test.test'|obfuscate_email }}", '&#x74;e&#115;&#116;&#x40;t&#101;&#x73;t.&#x74;est' ],
        ];
    }
}
