<?php

declare(strict_types=1);

namespace Evoluted\StatamicTwig\Twig;

use Statamic\Modifiers\CoreModifiers;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class StatamicExtension extends AbstractExtension
{
    /**
     * @return array<TwigFilter>
     */
    public function getFilters(): array
    {
        return [
            new TwigFilter('add_slashes', [ CoreModifiers::class, 'addSlashes' ], [ 'is_safe' => [ 'html' ]]),
            $this->proxyParams('ampersand_list', 'ampersandList'),
            new TwigFilter('ascii', [ CoreModifiers::class, 'ascii' ]),
            new TwigFilter('background_position', [ CoreModifiers::class, 'backgroundPosition' ]),
            $this->proxyParams('backspace'),
            new TwigFilter('obfuscate_email', [ CoreModifiers::class, 'obfuscateEmail' ], [ 'is_safe' => [ 'html' ]]),
        ];
    }

    /**
     * For variadic filters Twig requires the array parameter to have a default blank array which CoreModifiers doesn't
     * provide, so even though they're mostly suitable as-is, Twig won't use them without us proxying them
     *
     * @param array<string,mixed> $options
     */
    private function proxyParams(string $filterName, ?string $methodName = null, array $options = []): TwigFilter
    {
        $methodName ??= $filterName;

        return new TwigFilter(
            $filterName,
            fn(mixed $v, array $p = []): mixed => (new CoreModifiers())->{$methodName}($v, $p),
            array_merge([ 'is_variadic' => true ], $options)
        );
    }
}
