# Statamic Twig

Addon to enable the [Twig](https://twig.symfony.com/) templating engine for [Statamic CMS](https://statamic.com/).

## Installation

Use the normal [Statamic method for addon installation](https://statamic.dev/addons#installing-addons):

```shell
composer require evoluted/statamic-twig
```

## Compatibility

The Statamic Twig addon is compatible with:

1. Statamic CMS 3.3
2. Twig 3.4
3. PHP 8.1

## Features

This addon attempts to provide as seamless as transition from Antlers as possible. Where there is built in Antlers functionality that already has a Twig equivalent, the Twig functionality has been used.

### Modifiers

[Statamic modifiers](https://statamic.dev/reference/modifiers) are almost identical to [Twig's filters](https://twig.symfony.com/doc/3.x/templates.html#filters). Converting from Antlers modifier syntax to Twig should be straightforward

```antlers
{{ books | add:magazines }}
```

would become:

```twig
{{ books | add(magazines) }}
```

| Modifier            | Available | Twig native |
|---------------------|-----------|-------------|
| add                 | ✗         | ✗           |
| add_slashes         | ✓         | ✗           |
| ampersand_list      | ✓         | ✗           |
| as                  | ✗         | ✗           |
| ascii               | ✓         | ✗           |
| at                  | ✗         | ✗           |
| background_position | ✓         | ✗           |
| backspace           | ✓         | ✗           |
| camelize            | ✗         | ✗           |
| cdata               | ✗         | ✗           |
| ceil                | ✗         | ✗           |
| chunk               | ✗         | ✗           |
| collapse            | ✗         | ✗           |
| collapse_whitespace | ✗         | ✗           |
| compact             | ✗         | ✗           |
| console_log         | ✗         | ✗           |
| contains            | ✗         | ✗           |
| contains_all        | ✗         | ✗           |
| contains_any        | ✗         | ✗           |
| count               | ✗         | ✗           |
| count_substring     | ✗         | ✗           |
| dashify             | ✗         | ✗           |
| days_ago            | ✗         | ✗           |
| decode              | ✗         | ✗           |
| deslugify           | ✗         | ✗           |
| divide              | ✗         | ✗           |
| dl                  | ✗         | ✗           |
| dump                | ✗         | ✗           |
| embed_url           | ✗         | ✗           |
| ends_with           | ✗         | ✗           |
| ensure_left         | ✗         | ✗           |
| ensure_right        | ✗         | ✗           |
| entities            | ✗         | ✗           |
| excerpt             | ✗         | ✗           |
| explode             | ✗         | ✗           |
| favicon             | ✗         | ✗           |
| first               | ✗         | ✗           |
| flatten             | ✗         | ✗           |
| flip                | ✗         | ✗           |
| floor               | ✗         | ✗           |
| format              | ✗         | ✗           |
| format_localized    | ✗         | ✗           |
| format_number       | ✗         | ✗           |
| full_urls           | ✗         | ✗           |
| get                 | ✗         | ✗           |
| gravatar            | ✗         | ✗           |
| group_by            | ✗         | ✗           |
| has_lower_case      | ✗         | ✗           |
| has_upper_case      | ✗         | ✗           |
| hours_ago           | ✗         | ✗           |
| image               | ✗         | ✗           |
| in_array            | ✗         | ✗           |
| insert              | ✗         | ✗           |
| is_after            | ✗         | ✗           |
| is_alpha            | ✗         | ✗           |
| is_alphanumeric     | ✗         | ✗           |
| is_array            | ✗         | ✗           |
| is_before           | ✗         | ✗           |
| is_between          | ✗         | ✗           |
| is_blank            | ✗         | ✗           |
| is_email            | ✗         | ✗           |
| is_embeddable       | ✗         | ✗           |
| is_empty            | ✗         | ✗           |
| is_future           | ✗         | ✗           |
| is_json             | ✗         | ✗           |
| is_leap_year        | ✗         | ✗           |
| is_lowercase        | ✗         | ✗           |
| is_numberwang       | ✗         | ✗           |
| is_numeric          | ✗         | ✗           |
| is_past             | ✗         | ✗           |
| is_today            | ✗         | ✗           |
| is_tomorrow         | ✗         | ✗           |
| is_uppercase        | ✗         | ✗           |
| is_url              | ✗         | ✗           |
| is_weekday          | ✗         | ✗           |
| is_weekend          | ✗         | ✗           |
| is_yesterday        | ✗         | ✗           |
| iso_format          | ✗         | ✗           |
| join                | ✗         | ✗           |
| last                | ✗         | ✗           |
| lcfirst             | ✗         | ✗           |
| length              | ✗         | ✗           |
| limit               | ✗         | ✗           |
| link                | ✗         | ✗           |
| list                | ✗         | ✗           |
| lower               | ✗         | ✗           |
| macro               | ✗         | ✗           |
| mailto              | ✗         | ✗           |
| markdown            | ✗         | ✗           |
| md5                 | ✗         | ✗           |
| minutes_ago         | ✗         | ✗           |
| mod                 | ✗         | ✗           |
| modify_date         | ✗         | ✗           |
| months_ago          | ✗         | ✗           |
| multiply            | ✗         | ✗           |
| nl2br               | ✗         | ✗           |
| obfuscate           | ✗         | ✗           |
| obfuscate_email     | ✗         | ✗           |
| offset              | ✗         | ✗           |
| ol                  | ✗         | ✗           |
| option_list         | ✗         | ✗           |
| output              | ✗         | ✗           |
| pad                 | ✗         | ✗           |
| parse_url           | ✗         | ✗           |
| partial             | ✗         | ✗           |
| pathinfo            | ✗         | ✗           |
| piped               | ✗         | ✗           |
| plural              | ✗         | ✗           |
| raw                 | ✗         | ✗           |
| rawurlencode        | ✗         | ✗           |
| ray                 | ✗         | ✗           |
| read_time           | ✗         | ✗           |
| regex_replace       | ✗         | ✗           |
| relative            | ✗         | ✗           |
| remove_left         | ✗         | ✗           |
| remove_right        | ✗         | ✗           |
| repeat              | ✗         | ✗           |
| replace             | ✗         | ✗           |
| reverse             | ✗         | ✗           |
| round               | ✗         | ✗           |
| safe_truncate       | ✗         | ✗           |
| sanitize            | ✗         | ✗           |
| seconds_ago         | ✗         | ✗           |
| segment             | ✗         | ✗           |
| sentence_list       | ✗         | ✗           |
| shuffle             | ✗         | ✗           |
| singular            | ✗         | ✗           |
| slugify             | ✗         | ✗           |
| smartypants         | ✗         | ✗           |
| sort                | ✗         | ✗           |
| spaceless           | ✗         | ✗           |
| starts_with         | ✗         | ✗           |
| strip_tags          | ✗         | ✗           |
| substr              | ✗         | ✗           |
| subtract            | ✗         | ✗           |
| sum                 | ✗         | ✗           |
| surround            | ✗         | ✗           |
| swap_case           | ✗         | ✗           |
| table               | ✗         | ✗           |
| tidy                | ✗         | ✗           |
| timezone            | ✗         | ✗           |
| title               | ✗         | ✗           |
| to_json             | ✗         | ✗           |
| to_spaces           | ✗         | ✗           |
| to_tabs             | ✗         | ✗           |
| trim                | ✗         | ✗           |
| truncate            | ✗         | ✗           |
| ucfirst             | ✗         | ✗           |
| ul                  | ✗         | ✗           |
| underscored         | ✗         | ✗           |
| unique              | ✗         | ✗           |
| upper               | ✗         | ✗           |
| url                 | ✗         | ✗           |
| urldecode           | ✗         | ✗           |
| urlencode           | ✗         | ✗           |
| weeks_ago           | ✗         | ✗           |
| where               | ✗         | ✗           |
| widont              | ✗         | ✗           |
| word_count          | ✗         | ✗           |
| wrap                | ✗         | ✗           |
| years_ago           | ✗         | ✗           |
