<?php
App::uses('EvSocialScheduleAppModel', 'EvSocialSchedule.Model');
/**
 * ScheduleMessage Model
 *
 * @property QueuedTask $QueuedTask
 * @property  $
 * @property SocialNetwork $SocialNetwork
 */
class Message extends EvSocialScheduleAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'text';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'text' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

	// The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'QueuedTask' => array(
			'className' => 'QueuedTask',
			'foreignKey' => 'queued_task_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'' => array(
			'className' => '',
			'foreignKey' => 'id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

/**
 * hasAndBelongsToMany associations
 *
 * @var array
 */
	public $hasAndBelongsToMany = array(
		'SocialNetworkAccount' => array(
			'className' => 'EvSocialSchedule.SocialNetworkAccount',
			'joinTable' => 'ev_social_schedule_messages_social_network_accounts',
			'foreignKey' => 'message_id',
			'associationForeignKey' => 'social_network_account_id',
			'unique' => 'keepExisting',
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'finderQuery' => '',
		)
	);

	public function readForEdit($id, $params = array()) {
		$params['contain'][] = 'SocialNetworkAccount';

		return parent::readForEdit($id, $params);
	}

	public function afterSave($created = false, $options = array()) {
		parent::afterSave($created, $options);

		$QueuedTask = EvClassRegistry::init('Queue.QueuedTask');

		if (isset($this->data['Message']['queued_task_id']) && $this->data['Message']['queued_task_id'] > 0) {
			// Update task
			$task = $QueuedTask->findById($this->data['Message']['queued_task_id']);

			if (! empty($task)) {
				$task['QueuedTask']['data'] = serialize(['id' => $this->data['Message']['id']]);
				$QueuedTask->save($task);
			}
		} else {
			// Create task
			$task = $QueuedTask->createJob('SocialSchedule', ['id' => $this->data['Message']['id']], $this->data['Message']['publish_date']);

			$this->save([
				'Message' => [
					'id' => $this->data['Message']['id'],
					'queued_task_id' => $task['QueuedTask']['id']
				]
			]);
		}
	}
}
